<?php
// This code goes right into your functions.php file
// ----------------------------------------------------------------------------- caption -----------------
add_shortcode('wp_caption', 'pola_img_caption_shortcode');
add_shortcode('caption', 'pola_img_caption_shortcode');
function pola_img_caption_shortcode($attr, $content = null) {
	// Allow plugins/themes to override the default caption template.
	$output = apply_filters('img_caption_shortcode', '', $attr, $content);
	if ( $output != '' ) return $output;
	extract(shortcode_atts(array(
		'id'		=> '',
		'align'		=> 'alignnone',
		'width'		=> '',
		'caption'	=> ''), $attr));
	if ( 1 > (int) $width || empty($caption) )
	    return $content;
	if ( $id ) $id = 'id="' . esc_attr($id) . '" ';
	return '<span ' . $id . 'class="wp-caption wp-caption' . ((int) $width) . ' ' . esc_attr($align)	// We add a new class "wp-captionXXX" and the <div> become a <span>
	. '" style="width: ' . ((int) $width) . 'px">'								// We don't need the original 10px, it's our style sheet work
	. do_shortcode($content) . '<span class="wp-caption-text">'						// The <p> become a <span>
	. $caption . '</span></span>';
}
?>