<?php
// This code goes right into your functions.php file
// ----------------------------------------------------------------------------- gallery -----------------
add_filter('post_gallery', 'sf_post_gallery', 10, 2);

function sf_post_gallery($null, $attr = array()) {
	global $post, $wp_locale;
	static $instance = 0;
	$instance++;
						// We don't need the "apply_filters" function here, unless you want to mess up all. So we delete it
	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}
	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post->ID,
		'itemtag'    => '',		// We don't need 'dl'
		'icontag'    => '',		// We don't need 'dt'
		'captiontag' => '',		// We don't need 'dd'
		'columns'    => 3,
		'size'       => 'medium',	// We'll use medium instead of thumbnail
		'include'    => '',
		'exclude'    => ''
	), $attr));

	$id = intval($id);
	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) {
		$include = preg_replace( '/[^0-9,]+/', '', $include );
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';

	$output = "<div id='gallery-{$instance}' class='gallery galleryid-{$id}'>";	// We don't need the style tag, so we delete it

	if($itemtag != '' && $icontag != '' && $captiontag != '') {			// If we have specified the tags in the shortcode, let's use them with the original structure
		$i = 0;
		foreach ( $attachments as $id => $attachment ) {
			$link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);

			$output .= "<{$itemtag} class='gallery-item'>";
			$output .= "
				<{$icontag} class='gallery-icon'>
					$link
				</{$icontag}>";
			if ( $captiontag && trim($attachment->post_excerpt) ) {
				$output .= "
					<{$captiontag} class='gallery-caption'>
					" . wptexturize($attachment->post_excerpt) . "
					</{$captiontag}>";
			}
			$output .= "</{$itemtag}>";
			if ( $columns > 0 && ++$i % $columns == 0 )
				$output .= '<br style="clear: both" />';
		}
	} else {												// Else, we use our custom gallery
		foreach ( $attachments as $id => $attachment ) {
			$thumb = wp_get_attachment_image_src( $id, $size );					// We get the medium size image representing, it returns an array [url] [width] [height]
			$caption = wptexturize($attachment->post_excerpt);					// The caption text
			$output .= '[caption id="attachment_'.$id.'" align="alignleft" width="'.$thumb[1].'" caption="' . $caption . '&nbsp;"]';	// We use the caption shortcode
			if (isset($attr['link']) && 'file' == $attr['link']) {					// If we want to link directly to the file
				$image = wp_get_attachment_image_src( $id, 'full' );				// We get the full size image representing, we'll use it to retrieve its url with $image[0]
				$output .= '<a href="'.$image[0].'" rel="prettyPhoto[pp'.$instance.']">';	// The link: $image[0] is the url, we put a rel attribute for a lightbox (you can put what you want)
				$output .= '<img class="attachment-'.$size.'" width="'.$thumb[1].'" height="'.$thumb[2].'" title="'.$caption.'" alt="'.$caption.'" src="'.$thumb[0].'" />';	// The "thumbnail"
				$output .= '</a>';
			} else {
				$output .= wp_get_attachment_link($id, $size, true, false);			// Link to the attachment page
			}
			$output .= '[/caption] ';								// We close the caption shortcode
		}
		$output = do_shortcode($output);								// We finally apply a do_shortcode for the... caption shortcodes ;)
	}

	$output .= "
			<br style='clear: both;' />
		</div>\n";											// Clear the thumbs floats and close the gallery div

	return $output;
}
?>