jQuery(document).ready(function($){

	function initform(){									// Init form function
		$('#submit').removeAttr('disabled');
		$('#envelope').removeClass();
	}

	function formerror(){									// Function when an error occurs
		$('#envelope').addClass('notsent');
		$('#submit').removeAttr('disabled');
	}

	initform();												// Init on page load

	$('form').submit(function(e){

		$('#submit').attr('disabled','disabled');			// Disable submit button
		$('#envelope').removeClass();

		$.ajax({
			type: 'POST',
			url: 'contact.php',
			data: $('form').serialize(),
			timeout: 4000,
			success: function(data){
				if(data == 'ok')
					$('#envelope').attr('class', 'sent');	// Success
				else
					formerror();							// Simulate an error
			}
		}).error(
			function(){
				formerror();								// Real error
			}
		);
		e.preventDefault();

	}).find('#submit').removeAttr('disabled');				// Init on page load

	$('#play-again').click(function(){						// Play agin button
		initform();
	})
})