<?php
/*
 * Plugin Name: Grant me Super Admin
 * Plugin URI: http://www.screenfeed.fr/
 * Description: If you're an Admin in a multisite installation, let's become Super Admin.
 * Version: 1.0
 * Author: Grégory Viguier
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt
 */

if ( ! defined( 'ABSPATH' ) )
	die( 'Cheatin\' uh?' );



// Grant me as Network Admin and add me to all sites.

add_action( 'init', 'grant_me_super_admin' );

function grant_me_super_admin() {
	// CHANGE ME! -----------------------------------

	$user_id = 0;

	// ----------------------------------------------

	$current = get_current_user_id();

	if ( ! $user_id || $user_id !== $current || ! is_admin() || ! is_multisite() || ! current_user_can( 'manage_options' ) ) {
		return;
	}

	if ( ! function_exists('grant_super_admin') ) {
		require_once( ABSPATH . 'wp-admin/includes/ms.php' );
	}

	// SUPER POWER!
	grant_super_admin( $user_id );

	// Add me to all relevant sites.
	$sites = gmsa_get_sites();
	$user_blogs = get_blogs_of_user( $user_id );

	if ( ! empty( $sites ) && ! empty( $user_blogs ) ) {

		$sites = array_map( 'absint', wp_list_pluck( $sites, 'blog_id' ) );
		$user_blogs = array_map( 'absint', array_keys( $user_blogs ) );

		foreach ( $sites as $blog_id ) {
			if ( ! in_array( $blog_id, $user_blogs ) ) {
				add_user_to_blog( $blog_id, $user_id, 'administrator' );
			}
		}

	}
}



// !Add my user ID in the admin bar (profile dropdown).

add_action( 'admin_bar_menu', 'tell_me_my_user_id_pliz' );

function tell_me_my_user_id_pliz( $wp_admin_bar ) {
	if ( ! is_admin() || ! is_multisite() || ! current_user_can( 'manage_options' ) ) {
		return;
	}

	$wp_admin_bar->add_menu( array(
		'parent' => 'user-actions',
		'id'     => 'user-id',
		'title'  => get_current_user_id(),
	) );
}



// !wp_get_sites() replacement for WordPress < 3.7

function gmsa_get_sites() {
	global $wpdb;

	if ( function_exists( 'wp_get_sites' ) ) {
		return wp_get_sites( array(
			'archived'	=> 0,
			'spam'		=> 0,
			'deleted'	=> 0,
		) );
	}

	$count = get_blog_count();
	if ( apply_filters( 'wp_is_large_network', $count > 10000, 'sites', $count ) ) {
		return array();
	}

	$network_ids = array( $wpdb->siteid );

	$query = "SELECT * FROM $wpdb->blogs WHERE 1=1 AND site_id IN ($network_ids) AND archived = 0 AND spam = 0 AND deleted = 0 LIMIT 100";

	return $wpdb->get_results( $query, ARRAY_A );
}
/**/