<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

// !Date field
if ( ! function_exists( 'noop_date_field' ) ) :

function noop_date_field( $o ) {
	global $wp_locale;
	static $fields, $first_field, $default_format;

	if ( ( empty( $o['label_for'] ) && empty( $o['name'] ) ) || empty( $o['option_name'] ) ) {
		return;
	}

	if ( is_null( $first_field ) ) {
		$first_field = 'mm';
		// < 3.6
		if ( Noop::version_compare( '3.6' ) < 0 ) {
			$fields         = __( '%1$s%2$s, %3$s @ %4$s : %5$s' );
			$default_format = sprintf( $fields, 'F', ' d', 'Y', 'H', 'i' );
		}
		// < 4.3
		elseif ( Noop::version_compare( '4.3' ) < 0 ) {
			$fields         = __( '%1$s %2$s, %3$s @ %4$s : %5$s' );
			$default_format = sprintf( $fields, 'F', 'd', 'Y', 'H', 'i' );
		}
		// >= 4.3
		else {
			$fields         = __( '%1$s %2$s, %3$s @ %4$s:%5$s' );
			$default_format = sprintf( $fields, 'F', 'd', 'Y', 'H', 'i' );
		}

		if ( preg_match( '@\d@', $fields, $matches ) ) {
			$first_field = (int) $matches[0];

			switch ( $first_field ) {
				case 2:
					$first_field = 'jj';
					break;
				case 3:
					$first_field = 'aa';
			}
		}
	}

	$o = array_merge( array(
		'label_for'      => '',		// (1)
		'name'           => '',		// (1)
		'label'          => '',
		'value'          => null,

		'class'          => '',

		'fallback_today' => false	// If no date, fallback to today date
	), $o );
	extract( $o, EXTR_SKIP );

	$id   = $label_for ? $label_for : $name;
	$name = $name ? $name : $id;

	if ( is_null( $value ) ) {
		if ( false !== strpos( $name, '|' ) ) {
			$exploded_name = explode( '|', $name );
			$value         = Noop_Fields::get_deep_array_val( $options, $exploded_name );
		}
		else {
			$value = $options[ $name ];
		}
	}
	$name = str_replace( '|', '][', $name );

	// Default value
	if ( isset( $defaults ) ) {
		if ( false !== strpos( $name, '][' ) ) {
			$exploded_name = explode( '][', $name );
			$default = Noop_Fields::get_deep_array_val( $defaults, $exploded_name );

			if ( $default && '0000-00-00 00:00:00' !== $default ) {
				$default = date_i18n( $default_format, mysql2timestamp( $default ) );
				$o['defaults'] = Noop_Fields::set_deep_array_val( $default, $exploded_name, $defaults );
			}
			elseif ( '0000-00-00 00:00:00' === $default ) {
				$o['defaults'] = Noop_Fields::set_deep_array_val( '', $exploded_name, $defaults );
			}
		} else {
			if ( $defaults[ $name ] && '0000-00-00 00:00:00' !== $defaults[ $name ] ) {
				$o['defaults'][ $name ] = date_i18n( $default_format, mysql2timestamp( $defaults[ $name ] ) );
			}
			elseif ( '0000-00-00 00:00:00' === $defaults[ $name ] ) {
				$o['defaults'][ $name ] = '';
			}
		}
	}

	$edit = $value && '0000-00-00 00:00:00' !== $value;

	if ( $fallback_today ) {
		$time_adj = current_time( 'timestamp' );
		$cur_jj   = gmdate( 'd', $time_adj );
		$cur_mm   = gmdate( 'm', $time_adj );
		$cur_aa   = gmdate( 'Y', $time_adj );
		$cur_hh   = gmdate( 'H', $time_adj );
		$cur_mn   = gmdate( 'i', $time_adj );
	}
	else {
		$cur_jj = $cur_mm = $cur_aa = $cur_hh = $cur_mn = '';
	}

	$jj = $edit ? mysql2date( 'd', $value, false ) : $cur_jj;
	$mm = $edit ? mysql2date( 'm', $value, false ) : $cur_mm;
	$aa = $edit ? mysql2date( 'Y', $value, false ) : $cur_aa;
	$hh = $edit ? mysql2date( 'H', $value, false ) : $cur_hh;
	$mn = $edit ? mysql2date( 'i', $value, false ) : $cur_mn;

	$name  = $option_name . ( ! empty( $locales['locale'] ) ? '[' . $locales['locale'] . ']' : '' ) . '[' . $name . ']';
	$class = ' ' . trim( $class );

	$month  = '<label><span class="screen-reader-text">' . __( 'Month' ) . '</span><select name="' . $name . '[mm]" class="mm' . $class . '"' . ( $first_field === 'mm' ? ' id="' . $id . '"' : '' ) . ">\n";
	$month .= "\t\t\t" . '<option value="">' . __( 'Select Month' ) . "</option>\n";
	for ( $i = 1; $i < 13; $i = $i + 1 ) {
		$monthnum = zeroise( $i, 2 );
		$month .= "\t\t\t" . '<option value="' . $monthnum . '"';
		if ( $i === (int) $mm ) {
			$month .= ' selected="selected"';
		}
		$month .= '>' . sprintf( __( '%1$s-%2$s' ), $monthnum, $wp_locale->get_month_abbrev( $wp_locale->get_month( $i ) ) ) . "</option>\n";
	}
	$month .= '</select></label>';

	$day    = '<label><span class="screen-reader-text">' . __( 'Day' ) . '</span><input type="text" name="' . $name . '[jj]" value="' . $jj . '" size="2" class="jj' . $class . '" maxlength="2" autocomplete="off"' . ( $first_field === 'jj' ? ' id="' . $id . '"' : '' ) . ' /></label>';
	$year   = '<label><span class="screen-reader-text">' . __( 'Year' ) . '</span><input type="text" name="' . $name . '[aa]" value="' . $aa . '" size="4" class="aa' . $class . '" maxlength="4" autocomplete="off"' . ( $first_field === 'aa' ? ' id="' . $id . '"' : '' ) . ' /></label>';
	$hour   = '<label><span class="screen-reader-text">' . __( 'Hour' ) . '</span><input type="text" name="' . $name . '[hh]" value="' . $hh . '" size="2" class="hh' . $class . '" maxlength="2" autocomplete="off" /></label>';
	$minute = '<label><span class="screen-reader-text">' . __( 'Minute' ) . '</span><input type="text" name="' . $name . '[mn]" value="' . $mn . '" size="2" class="mn' . $class . '" maxlength="2" autocomplete="off" /></label>';

	echo "\t\t\t\t";
	echo '<div class="timestamp-wrap settings-timestamp">';

		echo $label ? '<label for="' . $id . '">' . $label . '</label> ' : '';
		printf( $fields, $month, $day, $year, $hour, $minute );
		echo ' &#160; <input class="date-now hide-if-no-js button" type="button" value="' . esc_attr__( 'Right Now' ) . '"/>';

		echo Noop_Fields::get_instance( $option_name )->default_and_description( $o );

	echo '</div><input type="hidden" name="' . $name . '[ss]" value="00" />';

	wp_enqueue_script( 'noop-settings' );

	// CSS
	Noop_Fields::date_icon_css();
}

endif;
