<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

// !Date field
if ( ! function_exists( 'noop_month_year_field' ) ) :

function noop_month_year_field( $o ) {
	global $wp_locale;
	static $fields, $first_field, $default_format;

	if ( ( empty( $o['label_for'] ) && empty( $o['name'] ) ) || empty( $o['option_name'] ) ) {
		return;
	}

	if ( is_null( $first_field ) ) {
		$fields         = _x( '%1$s, %2$s', '1: month input, 2: year input, arranged as a date', 'noop' );
		$first_field    = 'mm';
		$default_format = sprintf( $fields, 'F', 'Y' );

		if ( preg_match( '@\d@', $fields, $matches ) ) {
			$first_field = ( (int) $matches[0] === 2 ) ? 'aa' : 'mm';
		}
	}

	$o = array_merge( array(
		'label_for'      => '',		// (1)
		'name'           => '',		// (1)
		'label'          => '',
		'value'          => null,

		'class'          => '',

		'fallback_today' => false	// If no date, fallback to today date
	), $o );
	extract( $o, EXTR_SKIP );

	$id   = $label_for ? $label_for : $name;
	$name = $name ? $name : $id;

	if ( is_null( $value ) ) {
		if ( false !== strpos( $name, '|' ) ) {
			$exploded_name = explode( '|', $name );
			$value         = Noop_Fields::get_deep_array_val( $options, $exploded_name );
		}
		else {
			$value = $options[ $name ];
		}
	}
	$name = str_replace( '|', '][', $name );

	// Default value
	if ( isset( $defaults ) ) {
		if ( false !== strpos( $name, '][' ) ) {
			$exploded_name = explode( '][', $name );
			$default = Noop_Fields::get_deep_array_val( $defaults, $exploded_name );

			if ( $default && '0000-00' !== $default ) {
				$default = explode( '-', $default );
				$default = date_i18n( $default_format, mktime( 0, 0, 0, (int) $default[1], 1, (int) $default[0] ) );
				$o['defaults'] = Noop_Fields::set_deep_array_val( $default, $exploded_name, $defaults );
			}
			elseif ( '0000-00' === $default ) {
				$o['defaults'] = Noop_Fields::set_deep_array_val( '', $exploded_name, $defaults );
			}
		}
		else {
			if ( $defaults[ $name ] && '0000-00' !== $defaults[ $name ] ) {
				$default = explode( '-', $defaults[ $name ] );
				$default = date_i18n( $default_format, mktime( 0, 0, 0, (int) $default[1], 1, (int) $default[0] ) );
				$o['defaults'][ $name ] = $default;
			}
			elseif ( '0000-00' === $defaults[ $name ] ) {
				$o['defaults'][ $name ] = '';
			}
		}
	}

	$edit = $value && '0000-00' !== $value;

	if ( $fallback_today ) {
		$time_adj = current_time( 'timestamp' );
		$cur_mm   = gmdate( 'm', $time_adj );
		$cur_aa   = gmdate( 'Y', $time_adj );
	} else {
		$cur_mm   = '';
		$cur_aa   = '';
	}

	$mm     = $edit ? mysql2date( 'm', $value, false ) : $cur_mm;
	$aa     = $edit ? mysql2date( 'Y', $value, false ) : $cur_aa;

	$name   = $option_name . ( ! empty( $locales['locale'] ) ? '[' . $locales['locale'] . ']' : '' ) . '[' . $name . ']';
	$class  = ' ' . trim( $class );

	$month  = '<select name="' . $name . '[mm]" class="mm' . $class . '"' . ( 'mm' === $first_field ? ' id="' . $id . '"' : '' ) . ">\n";
	$month .= "\t\t\t" . '<option value="">' . __( 'Select Month' ) . "</option>\n";
	for ( $i = 1; $i < 13; $i = $i + 1 ) {
		$monthnum = zeroise( $i, 2 );
		$month   .= "\t\t\t" . '<option value="' . $monthnum . '"';
		if ( $i === (int) $mm ) {
			$month .= ' selected="selected"';
		}
		$month .= '>' . sprintf( __( '%1$s-%2$s' ), $monthnum, $wp_locale->get_month_abbrev( $wp_locale->get_month( $i ) ) ) . "</option>\n";
	}
	$month .= '</select>';

	$year = '<input type="text" name="' . $name . '[aa]" value="' . $aa . '" size="4" class="aa' . $class . '" maxlength="4" autocomplete="off"' . ( 'aa' === $first_field ? ' id="' . $id . '"' : '' ) . ' />';

	echo "\t\t\t\t";
	echo '<div class="timestamp-wrap settings-timestamp">';

		echo $label ? '<label for="' . $id . '">' . $label . '</label> ' : '';
		printf( $fields, $month, $year );

		echo Noop_Fields::get_instance( $option_name )->default_and_description( $o );

	echo '</div>';

	// CSS
	Noop_Fields::date_icon_css();
}

endif;
