jQuery( document ).ready( function( $ ) {

	// !Make sure wpActiveEditor exists if we don't have tinyMCE --------------------------------------------------------------------------------------------------------------------------------------------------------------
	if ( "object" !== typeof( window.tinymce ) ) {
		$( "#wpbody-content .wrap" ).on( "click", ".wp-editor-wrap", function( e ) {
			if ( this.id ) {
				window.wpActiveEditor = this.id.slice( 3, -5 );
			}
		} );
	}

	// !Metaboxes -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	if ( "object" === typeof( window.postboxes ) && "undefined" === typeof( window.WPRemoveThumbnail ) ) {
		window.postboxes.add_postbox_toggles( window.pagenow );
	}

	// !"Fill" button (placeholder) -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	var inputPlaceholderSupport = document.createElement( "input" );

	if ( "placeholder" in inputPlaceholderSupport ) {
		$( ".fill-placeholder-button" ).on( "click", function( e ) {
			var $input = $( this ).addClass( "hidden" ).prev( "input" );

			e.preventDefault();

			$input.val( $input.attr( "placeholder" ).replace( /\.{3,}$/, "" ).replace( /\u2026$/, "" ) ).focus();

		} ).prev( "input" ).on( "blur", function( e ) {
			if ( "" === this.value ) {
				$( this ).next( ".fill-placeholder-button" ).removeClass( "hidden" );
			} else {
				$( this ).next( ".fill-placeholder-button" ).addClass( "hidden" );
			}
		} ).blur();
	}

	// !Inputs with "auto-select" ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	$( "input.auto-select, textarea.auto-select" ).on( "focus", function( e ) {
		$( this ).select();
	} ).on( "mouseup", function( e ) {
		e.preventDefault();
	} );

	// !Color picker ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	var $pickers = $( ".color-picker-hex" );

	if ( $pickers.length ) {
		// Color Picker bugfix
		$.wp.wpColorPicker.prototype.options.width = 255;
		$.wp.wpColorPicker.prototype._setOption = function( k, v ) {
			this.options[ k ] = v;
			this.element.iris( "option", k, v );
		};
		$.wp.wpColorPicker.prototype._create = function() {
			var _before = '<a tabindex="0" class="wp-color-result" />',
				_after  = '<div class="wp-picker-holder" />',
				_wrap   = '<div class="wp-picker-container" />',
				_button = '<input type="button" class="button button-small hidden" />',
				self    = this,
				el      = self.element;

			// bail early for IE < 8
			if ( $.browser.msie && Number( $.browser.version ) < 8 ) {
				return;
			}

			$.extend( self.options, el.data() );

			self.initialValue = el.val();

			// Set up HTML structure, hide things
			el.addClass( "wp-color-picker" ).hide().wrap( _wrap );
			self.wrap            = el.parent();
			self.toggler         = $( _before ).insertBefore( el ).css( { backgroundColor: self.initialValue } ).attr( "title", window.wpColorPickerL10n.pick ).attr( "data-current", window.wpColorPickerL10n.current );
			self.pickerContainer = $( _after ).insertAfter( el );
			self.button          = $( _button );

			if ( self.options.defaultColor ) {
				self.button.addClass( "wp-picker-default" ).val( window.wpColorPickerL10n.defaultString );
			} else {
				self.button.addClass( "wp-picker-clear" ).val( window.wpColorPickerL10n.clear );
			}

			el.wrap( '<span class="wp-picker-input-wrap" />' ).after( self.button );

			if ( ! self.options.palettes || "false" === self.options.palettes || "0" === self.options.palettes ) {
				self.options.palettes = false;
			} else if ( "true" === self.options.palettes || "1" === self.options.palettes || 1 === self.options.palettes ) {
				self.options.palettes = true;
			} else {
				self.options.palettes = self.options.palettes.split( "," );
			}

			el.iris( {
				target:   self.pickerContainer,
				hide:     true,
				width:    self.options.width,
				mode:     "hsv",
				palettes: self.options.palettes,
				change:   function( event, ui ) {
					self.toggler.css( { backgroundColor: ui.color.toString() } );
					// check for a custom cb
					if ( $.isFunction( self.options.change ) ) {
						self.options.change.call( this, event, ui );
					}
				}
			} );

			el.val( self.initialValue );

			self._addListeners();

			if ( ! self.options.hide ) {
				self.toggler.click();
			}
		};

		$pickers.siblings( ".default-value" ).remove();
		$pickers.each( function() {
			var $this        = $( this ),
				defaultColor = $this.data( "defaultColor" ),
				width        = $this.data( "width" ),
				pickerArgs   = { hide: true, palettes: $this.data( "palettes" ) };

			if ( "" !== defaultColor ) {
				pickerArgs.defaultColor = defaultColor;
			}
			if ( "undefined" !== typeof width && "" !== width ) {
				pickerArgs.width = Number( width );
			}

			$this.wpColorPicker( pickerArgs );
		} );
	}

	// !Date ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	function padZero( v ) {
		v = Number( v );
		return v > 9 ? v : "0" + v;
	}

	$( ".date-now" ).on( "click", function( e ) {
		var $cont = $( this ).closest( ".timestamp-wrap" ),
			now   = new Date();

		e.preventDefault();

		$cont.find( ".jj" ).val( padZero( now.getDate() ) );
		$cont.find( ".mm" ).find( 'option[value="' + padZero( now.getMonth() + 1 ) + '"]' ).attr( "selected", "selected" ).siblings().removeAttr( "selected" );
		$cont.find( ".aa" ).val( 1900 + now.getYear() );
		$cont.find( ".hh" ).val( padZero( now.getHours() ) );
		$cont.find( ".mn" ).val( padZero( now.getMinutes() ) );
	} );

	// !Uploading files -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	if ( $( ".upload-media-display" ).length ) {
		var file_frame       = {},
			no_preview_item  = '<li class="attachment no-attachment"><div class="attachment-preview"><span class="icon no-media-icon">&#160;</span></div></li>',
			get_preview_item = function( attachment ) {
				var size, template = '<li data-id="%id%" class="attachment media-attachment"><div class="attachment-preview type-%type% subtype-%subtype% %orientation%">%content%<button title="%delText%" class="close media-modal-icon">&#160;</button></div></li>';

				template = template.replace( "%id%", attachment.id ).replace( "%type%", attachment.type ).replace( "%subtype%", attachment.subtype ).replace( "%delText%", window.NoopSettingsL10n.del );

				if ( "image" === attachment.type ) {
					size = attachment.sizes.medium ? attachment.sizes.medium : attachment.sizes.full;

					return template.replace( "%orientation%", size.orientation ).replace( "%content%", '<div class="thumbnail"><div class="centered"><img src="' + size.url + '" alt=""/></div></div>' );
				}

				return template.replace( "%orientation%", "landscape" ).replace( "%content%", '<img class="icon" src="' + attachment.icon + '" alt=""/><div class="filename"><div>' + attachment.filename + '</div></div>' );
			};

		$( "#wpbody-content .wrap" ).on( "click", ".upload-media-button", function( e ) {
			e.preventDefault();

			var $this      = $( this ),
				image_size = $this.data( "image_size" ),											// If false, that means we have to return an ID, not an url
				multiple   = $this.data( "multiple" ),
				editor     = $this.data( "editor" );

			$this.blur();
			window.wpActiveEditor = editor;

			// If the media frame already exists, reopen it.
			if ( file_frame[ editor ] ) {
				file_frame[ editor ].open();
				return;
			}

			// Create the media frame.
			file_frame[ editor ] = window.wp.media.frames.file_frame = window.wp.media( {
				title:    $this.text(),	//$this.data('uploader_title'),
				button:   {
					text: $this.data( "uploader_button_text" )
				},
				library:  {
					type: $this.data( "media_mime" )	// '', uploaded, image, audio, video
				},
				multiple: multiple
			} );

			// When an image is selected, run a callback.
			file_frame[ editor ].on( "select", function() {
				var attachments       = file_frame[ editor ].state().get( "selection" ).toJSON(),
					ActiveEditor      = document.getElementById( editor ),							// The current "editor"
					editorValue       = ActiveEditor.value,											// The input value
					$attachments_wrap = $( ActiveEditor ).siblings( ".upload-media-display" ),		// Will contain the previews/icons.
					$no_attachment    = $attachments_wrap.children( ".no-attachment" ),
					response          = [],
					previews          = [],
					separator         = image_size ? "\n" : ",";

				$.each( attachments, function( i, attachment ) {
					if ( "image" === attachment.type ) {
						// Store the data into an array
						if ( ! image_size ) {
							response.push( attachment.id );
						} else if ( "object" === typeof( attachment.sizes[ image_size ] ) ) {
							response.push( attachment.sizes[ image_size ].url );
						} else {
							response.push( attachment.url );
						}
					} else {
						// Store the data into an array
						if ( ! image_size ) {
							response.push( attachment.id );
						} else {
							response.push( attachment.url );
						}
					}
					// Store the preview
					previews.push( get_preview_item( attachment ) );
				} );

				// Insert data into the input
				response = response.join( separator );

				if ( editorValue && multiple ) {
					ActiveEditor.value += separator + response;
				} else {
					ActiveEditor.value  = response;
				}

				// Insert previews
				if ( multiple ) {
					$no_attachment.remove();
					$attachments_wrap.append( previews.join( "" ) );
				} else {
					$attachments_wrap.html( previews.join( "" ) );
				}
			} );

			// Finally, open the modal
			file_frame[ editor ].open();
		} )

		// Remove an item
		.on( "click", ".upload-media-display .close", function( e ) {
			var $this        = $( this ),
				$item        = $this.parents( ".media-attachment" ).trigger( "click" ),				// trigger click to activate window.wpActiveEditor
				ActiveEditor = document.getElementById( window.wpActiveEditor ),
				ids, item_id;

			e.preventDefault();

			if ( ! $item.siblings( ".media-attachment" ).length ) {
				$item.replaceWith( no_preview_item );
				ActiveEditor.value = "";
			} else {
				ids     = ActiveEditor.value.split( "," );
				item_id = $item.data( "id" );
				idx     = ids.indexOf( "" + item_id );

				if ( -1 !== idx ) {
					ids.splice( idx, 1 );
					ActiveEditor.value = ids.join( "," );
					$item.remove();
				}
			}
		} );

		// Sortable medias when "multiple" is active
		var $sortableMediaCont   = $( ".upload-media-display.ui-sortable" ),
			updateEditorSortable = function() {
			var ids           = [],
				$ActiveEditor = $( document.getElementById( window.wpActiveEditor ) ),
				$wrap         = $ActiveEditor.siblings( ".upload-media-display" ),
				$items        = $wrap.children( ".media-attachment" );

			if ( $items.length ) {
				$items.each( function() {
					ids.push( $( this ).data( "id" ) );
				} ).siblings( ".no-attachment" ).remove();
			} else {
				$wrap.html( no_preview_item );
			}

			$ActiveEditor.val( ids.join( "," ) );
		};

		$sortableMediaCont.each( function() {
			$( this ).sortable( {
				items:       ".media-attachment",
				cancel:      ".media-modal-icon",
				revert:      200,
				connectWith: ".upload-media-display.ui-sortable",
				containment: ( $sortableMediaCont.length > 1 ? false : "parent" ),
				update: function( e, ui ) {
					if ( null !== ui.sender ) {
						ui.sender.parent( ".wp-editor-wrap" ).trigger( "click" );					// trigger click to activate window.wpActiveEditor
					} else {
						ui.item.parents( ".wp-editor-wrap" ).trigger( "click" );					// trigger click to activate window.wpActiveEditor
					}

					updateEditorSortable();
				},
				receive: function( e, ui ) {
					var receiverMime = ui.item.parent().siblings( ".upload-media-button" ).data( "media_mime" ),
						$maybeCancel = ui.item.parents( ".wp-editor-wrap" );						// After a "cancel", ui.item change! O__O (wtf!)

					if ( receiverMime && ! ui.item.children( ".attachment-preview" ).hasClass( "type-" + receiverMime ) ) {
						ui.sender.sortable( "cancel" );
						$maybeCancel.trigger( "click" );											// trigger click to activate window.wpActiveEditor
						updateEditorSortable();
					}
				}
			} );
		} ).disableSelection();
	}	// eo Uploading files

	// !Show/Hide fields depending on other fields value ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
	var $depends = $( ".form-table" ).find( 'tr[class*="depends-"]' );

	if ( $depends.length ) {
		var dependsFor        = [],
			NoopInputHasValue = function( trClass ) {	// trClass = ['meta-name', 'meta-value']
				var $inps = $( ".depfield-" + trClass[0] ),
					type  = $inps.first().attr( "type" ),
					out   = false;

				if ( "radio" === type ) {
					return $inps.filter( ":checked" ).val() === trClass[1];
				}

				if ( "checkbox" === type ) {
					$inps.filter( ":checked" ).each( function() {
						if ( $( this ).val() === trClass[1] ) {
							out = true;
						}
					} );

					return out;
				} else {
					return $inps.val() === trClass[1];
				}
			};

		// Get the inputs classes
		$depends.each( function() {
			var cls = $( this ).attr( "class" ).split( " " );

			$.each( cls, function( i, v ) {
				var depv;

				if ( -1 !== v.indexOf( "depends-" ) ) {
					depv = v.substr( 8 ).split( "___" );	// ['meta-name', 'meta-value']

					if ( -1 === dependsFor.indexOf( ".depfield-" + depv[0] ) ) {
						dependsFor.push( ".depfield-" + depv[0] );
					}
				}
			} );
		} );

		// Show/hide rows on inputs change
		if ( dependsFor.length ) {
			$( ".form-table" ).on( "change", dependsFor.join( "," ), function( e ) {
				var $this = $( this ),
					cls   = $this.attr( "class" ).split( " " ), cln, clv;

				$.each( cls, function( i, v ) {
					if ( -1 !== v.indexOf( "depfield-" ) ) {
						cln = v.substr( 9 );
						return false;
					}
				} );

				if ( ! cln ) {
					return true;
				}

				$( 'tr[class*="depends-' + cln + '___"]' ).each( function() {
					var trClasses = this.className.split( " " ),
						NoopDepts = {},
						showRow   = true;

					$.each( trClasses, function( i, trClass ) {
						if ( -1 !== trClass.indexOf( "depends-" ) ) {
							trClass = trClass.substr( 8 ).split( "___" );

							if ( ! NoopDepts[ trClass[0] ] ) {
								NoopDepts[ trClass[0] ] = {};
							}

							NoopDepts[ trClass[0] ][ trClass[1] ] = NoopInputHasValue( trClass );
						}
					} );

					$.each( NoopDepts, function( iName, iVals ) {
						var showTemp = false;

						$.each( iVals, function( iVal, show ) {
							if ( show ) {
								showTemp = true;
								return false;
							}
						} );

						if ( ! showTemp ) {
							showRow = false;
							return false;
						}
					} );

					if ( showRow ) {
						$( this ).removeClass( "hide-if-js" );
					} else {
						$( this ).addClass( "hide-if-js" );
					}
				} );
			} );
		}
	}

	// !Help pointers ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	var $help_pointers = $( ".help-pointer" );

	if ( $help_pointers.length ) {
		$help_pointers.each( function() {
			var $this = $( this );

			$( document.getElementById( $this.data( "target" ) ) ).pointer( {
				content:  "<h3>" + $this.data( "title" ) + "</h3><p>" + $this.attr( "title" ) + "</p>",
				position: {
					edge:  "top",
					align: "left"
				}
			} );

			$this.attr( "title", window.NoopSettingsL10n.help );

		} ).on( "click", function( e ) {
			$( document.getElementById( $( this ).data( "target" ) ) ).pointer( "toggle" );
			e.preventDefault();
		} );
	}

	// !Ajax pointers ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	if ( window.NoopAjaxPointers ) {
		$.each( window.NoopAjaxPointers, function( i, v ) {
			if ( ! window[ v ] ) {
				return true;
			}

			v = window[v];

			$( v.target ).pointer({
				content:  v.content,
				position: {
					edge:  v.edge,
					align: v.align
				},
				close:    function() {
					$.post( ajaxurl, {
						pointer: v.pointer_id,
						action:  "dismiss-wp-pointer"
					} );
				}
			} ).pointer( "open" );
		} );
	}

} );
