<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

// !Date field
if ( ! function_exists( 'noop_hour_minute_field' ) ) :

function noop_hour_minute_field( $o ) {
	global $wp_locale;
	static $fields, $first_field, $default_format;

	if ( ( empty( $o['label_for'] ) && empty( $o['name'] ) ) || empty( $o['option_name'] ) ) {
		return;
	}

	if ( is_null( $first_field ) ) {
		$fields         = _x( '%1$s h %2$s min', '1: hour input, 2: minutes input, arranged as a time', 'noop' );
		$first_field    = 'hh';
		$default_format = sprintf( $fields, 'H', 'i' );

		if ( preg_match( '@\d@', $fields, $matches ) ) {
			$first_field = ( (int) $matches[0] === 2 ) ? 'mn' : 'hh';
		}
	}

	$o = array_merge( array(
		'label_for'	     => '',		// (1)
		'name'           => '',		// (1)
		'label'          => '',
		'value'          => null,

		'class'          => '',

		'fallback_today' => false	// If no date, fallback to today date
	), $o );
	extract( $o, EXTR_SKIP );

	$id          = $label_for ? $label_for : $name;
	$name        = $name ? $name : $id;
	$time_format = get_option( 'time_format' );

	if ( is_null( $value ) ) {
		if ( false !== strpos( $name, '|' ) ) {
			$exploded_name = explode( '|', $name );
			$value         = Noop_Fields::get_deep_array_val( $options, $exploded_name );
		}
		else {
			$value = $options[ $name ];
		}
	}
	$name = str_replace( '|', '][', $name );

	// Default value
	if ( isset( $defaults ) ) {
		if ( false !== strpos( $name, '][' ) ) {
			$exploded_name = explode( '][', $name );
			$default       = Noop_Fields::get_deep_array_val( $defaults, $exploded_name );

			if ( $default && '00:00' !== $default ) {
				$default = explode( ':', $default );
				$default = date_i18n( $time_format, mktime( (int) $default[0], (int) $default[1], 0 ) );
				$o['defaults'] = Noop_Fields::set_deep_array_val( $default, $exploded_name, $defaults );
			}
			elseif ( '00:00' === $default ) {
				$o['defaults'] = Noop_Fields::set_deep_array_val( '', $exploded_name, $defaults );
			}
		}
		else {
			if ( $defaults[ $name ] && '00:00' !== $defaults[ $name ] ) {
				$default = explode( ':', $defaults[ $name ] );
				$default = date_i18n( $time_format, mktime( (int) $default[0], (int) $default[1], 0 ) );
				$o['defaults'][ $name ] = $default;
			}
			elseif ( '00:00' === $defaults[ $name ] ) {
				$o['defaults'][ $name ] = '';
			}
		}
	}

	if ( $fallback_today ) {
		$time_adj = current_time( 'timestamp' );
		$cur_hh   = date( 'H', $time_adj );
		$cur_mn   = date( 'i', $time_adj );
	}
	else {
		$cur_hh   = '';
		$cur_mn   = '';
	}

	$value  = $value && $value !== '00:00' ? explode( ':', $value ) : false;

	$hh     = $value ? $value[0] : $cur_hh;
	$mn     = $value ? $value[1] : $cur_mn;

	$name   = $option_name . ( ! empty( $locales['locale'] ) ? '[' . $locales['locale'] . ']' : '' ) . '[' . $name . ']';
	$class  = ' ' . trim( $class );
	$hour   = '<input type="text" name="' . $name . '[hh]" value="' . $hh . '" size="2" class="hh' . $class . '" maxlength="2" autocomplete="off"' . ( $first_field === 'hh' ? ' id="' . $id . '"' : '' ) . ' />';
	$minute = '<input type="text" name="' . $name . '[mn]" value="' . $mn . '" size="2" class="mn' . $class . '" maxlength="2" autocomplete="off"' . ( $first_field === 'mn' ? ' id="' . $id . '"' : '' ) . ' />';

	echo "\t\t\t\t";
	echo '<div class="timestamp-wrap settings-timestamp">';

		echo $label ? '<label for="' . $id . '">' . $label . '</label> ' : '';
		printf( $fields, $hour, $minute );

		echo Noop_Fields::get_instance( $option_name )->default_and_description( $o );

	echo '</div>';

	// CSS
	Noop_Fields::date_icon_css();
}

endif;
