<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

/*-----------------------------------------------------------------------------------*/
/* !Find Posts/Users =============================================================== */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_ajax_noop_find_posts', 'wp_ajax_noop_find_posts' );

if ( ! function_exists( 'wp_ajax_noop_find_posts' ) ) :

function wp_ajax_noop_find_posts() {
	global $wpdb, $wp_roles;

	check_ajax_referer( 'find-posts' );

	$s           = ! empty( $_POST['ps'] )   ? stripslashes( $_POST['ps'] ) : '';
	$what        = ! empty( $_POST['what'] ) ? esc_attr( $_POST['what'] )   : 'posts|||';
	$type        = ! empty( $_POST['type'] ) ? esc_attr( $_POST['type'] )   : 'any';
	$multiple    = ! empty( $_POST['multiple'] );

	$what        = explode( '|', $what );
	$page_name   = $what[1];
	$option_name = $what[2];
	$name        = str_replace( '][', '|', $what[3] );
	$what        = $what[0];

	do_action( 'before_wp_ajax_noop_find_posts', $page_name, $option_name, $name, $s, $what, $type, $multiple );

	// Find posts
	if ( 'posts' === $what || 'posts-thumb' === $what ) {

		$type       = explode( ',', $type );
		$post_types = array();

		if ( false !== ( $any_i = array_search( 'any', $type ) ) ) {
			$post_types = get_post_types( array( 'public' => true ), 'objects' );
			unset( $type[ $any_i ], $post_types['attachment'] );
		}
		if ( count( $type ) ) {
			$type       = array_combine( $type, $type );
			$type       = array_filter( $type, 'post_type_exists' );
			$type       = array_map( 'get_post_type_object', $type );
			$post_types = array_merge( $post_types, $type );
		}

		$post_status = array( 'publish' );

		if ( isset( $post_types['attachment'] ) || ! count( $post_types ) ) {
			$post_status[] = 'inherit';
		}

		$type = count( $post_types ) ? array_keys( $post_types ) : 'any';

		$args = array(
			'post_type'           => $type,
			'post_status'         => $post_status,
			'posts_per_page'      => 100,
			'ignore_sticky_posts' => true,
			'suppress_filters'    => false,
		);
		if ( '' !== $s ) {
			$args['s'] = $s;
		}
		if ( 'posts-thumb' === $what ) {
			$args['meta_query'] = array(
				array(
					'key'     => '_thumbnail_id',
					'value'   => 0,
					'type'    => 'NUMERIC',
					'compare' => '>',
				)
			);
			if ( isset( $post_types['attachment'] ) ) {
				$args['meta_query'][] = array(
					'key'     => '_wp_attachment_metadata',
					'value'   => ':"image/',
					'compare' => 'LIKE',
				);
				$args['meta_query']['relation'] = 'OR';
			}
		}

		$label_for = $name;
		$o         = compact( $what, $page_name, $option_name, $name, $label_for, $multiple, $type );
		$args      = apply_filters( 'noop_wp_query_args', $args, $o, 'noop_find_item_field' );
		$args      = apply_filters( 'noop_find_posts_args', $args, $what, $page_name, $option_name, $name, $multiple );

		$items     = get_posts( $args );

	}
	// Find users
	else {

		$args = array(
			'who' => $type,
		);
		if ( '' !== $s ) {
			$args['search'] = $s;
		}

		$args  = apply_filters( 'noop_find_posts_args', $args, $what, $page_name, $option_name, $name, $multiple );

		$items = get_users( $args );

	}

	$items = apply_filters( 'wp_ajax_noop_find_posts_items', $items, $args, $page_name, $option_name, $name, $s, $what, $type, $multiple );

	if ( ! $items ) {
		do_action( 'before_die_wp_ajax_noop_find_posts', $page_name, $option_name, $name, $s, $what, $type, $multiple );
		wp_die( __( 'No items found.' ) );
	}

	$_name = $name;

	if ( $multiple ) {
		$input_type = 'checkbox';
		$name       = '[]';
	}
	else {
		$input_type = 'radio';
		$name       = '';
	}

	if ( 'posts' === $what || 'posts-thumb' === $what ) {

		$statuses = wp_list_pluck( $GLOBALS['wp_post_statuses'], 'label' );

		if ( isset( $statuses['auto-draft'] ) ) {
			$statuses['auto-draft'] = __( 'Auto Draft' );
		}
		if ( isset( $statuses['inherit'] ) ) {
			$statuses['inherit'] = __( 'Inherited', 'noop' );
		}

		$html = '<table class="widefat" cellspacing="0"><thead><tr><th class="found-radio"><br /></th><th>' . __( 'Title' ) . '</th><th class="no-break">' . __( 'Type' ) . '</th><th class="no-break">' . __( 'Date' ) . '</th><th class="no-break">' . __( 'Status' ) . "</th></tr></thead><tbody>\n";

		foreach ( $items as $item ) {
			$title = trim( $item->post_title ) ? $item->post_title : __( '(no title)' );
			$stat  = ! empty( $statuses[ $item->post_status ] ) ? $statuses[ $item->post_status ] : __( 'None' );

			if ( '0000-00-00 00:00:00' === $item->post_date ) {
				$time = '';
			}
			else {
				/* translators: date format in table columns, see https://php.net/date */
				$time = mysql2date( __( 'Y/m/d' ), $item->post_date );
			}

			$data_image = '';
			if ( 'posts-thumb' === $what ) {
				if ( 'attachment' === $item->post_type && 'image' === substr( $item->post_mime_type, 0, 5 ) ) {
					$thumb_ID = $item->ID;
				}
				elseif ( $thumb_ID = (int) get_post_thumbnail_id( $item->ID ) ) {
					// Nada
				}
				else {
					continue;
				}

				list( $src, $width, $height ) = wp_get_attachment_image_src( $thumb_ID, 'medium' );
				$orientation = $width > $height ? 'landscape' : 'portrait';
				$subtype     = substr( get_post_mime_type( $thumb_ID ), 6 );
				$data_image  = ' data-image="' . $src . '|' . $orientation . '|' . $subtype . '"';
			}

			$html .= '<tr class="found-posts"><td class="found-' . $input_type . '"><input type="' . $input_type . '" id="found-' . $item->ID . '" name="found_post_id' . $name . '" value="' . esc_attr( $item->ID ) . '"' . $data_image . '></td>';
			$html .= '<td><label for="found-' . $item->ID . '">' . esc_html( $title ) . '</label></td><td class="no-break">' . esc_html( $post_types[ $item->post_type ]->labels->singular_name ) . '</td><td class="no-break">' . esc_html( $time ) . '</td><td class="no-break">' . esc_html( $stat ) . " </td></tr>\n\n";
		}

	}
	else {
		$html = '<table class="widefat" cellspacing="0"><thead><tr><th class="found-radio"><br /></th><th>' . __( 'Name' ) . '</th><th class="no-break">' . __( 'Role' ) . '</th><th class="no-break">' . __( 'ID' ) . '</th></tr></thead><tbody>';

		foreach ( $items as $item ) {
			$html .= '<tr class="found-posts"><td class="found-' . $input_type . '"><input type="' . $input_type . '" id="found-' . $item->ID . '" name="found_post_id' . $name . '" value="' . esc_attr( $item->ID ) . '"></td>';
			$html .= '<td><label for="found-' . $item->ID . '">' . esc_html( $item->display_name ) . '</label></td><td class="no-break">' . translate_user_role( $wp_roles->role_names[ $item->roles[0] ] ) . '</td><td class="no-break">' . esc_attr( $item->ID ) . "</td></tr>\n\n";
		}
	}

	$html .= '</tbody></table>';

	$html = apply_filters( 'wp_ajax_noop_find_posts_output', $html, $items, $args, $page_name, $option_name, $_name, $s, $what, $type, $multiple );

	if ( Noop::version_compare( '3.9-alpha' ) >= 0 ) {
		wp_send_json_success( $html );
	}

	$x = new WP_Ajax_Response();
	$x->add( array(
		'data' => $html
	) );
	$x->send();
}

endif;


/*-----------------------------------------------------------------------------------*/
/* !Geoloc an address ============================================================== */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_ajax_noop_geoloc_address', 'wp_ajax_noop_geoloc_address' );

if ( ! function_exists( 'wp_ajax_noop_geoloc_address' ) ) :

function wp_ajax_noop_geoloc_address() {

	check_ajax_referer( 'geoloc-address' );

	if ( empty( $_POST['address'] ) ) {
		noop_send_json_error( 'empty-address' );
	}

	// URL must be encoded for noop_geoloc().
	$address = urlencode( esc_attr( $_POST['address'] ) );

	$from = apply_filters( 'noop_geoloc_address_from', 'both', $address );
	$from = in_array( $from, array( 'both', 'google', 'osm' ) ) ? $from : 'both';

	if ( 'both' === $from ) {
		// First, try Google
		$response = noop_geoloc( $address );
		// May be Open Street Map if Google fails or if the result is approximative.
		if ( ! $response->success || $response->approx ) {
			$response = noop_geoloc( $address, 'osm' );
		}
	}
	else {
		$response = noop_geoloc( $address, $from );
	}

	// Fail?
	if ( ! $response->success ) {
		noop_send_json_error( 'nothing-found' );
	}

	noop_send_json_success( $response );
}

endif;


if ( ! function_exists( 'noop_geoloc' ) ) :

function noop_geoloc( $address, $from = 'google' ) {
	$out = (object) array(
		'success' => false,
		'lat'     => null,
		'lng'     => null,
		'approx'  => null,
	);

	// Google
	if ( 'google' === $from ) {
		$response = wp_remote_get( 'https://maps.googleapis.com/maps/api/geocode/json?sensor=false&address=' . $address );

		if ( is_wp_error( $response ) ) {
			return $out;
		}

		$response = json_decode( wp_remote_retrieve_body( $response ) );

		if ( ! $response || ! is_object( $response ) || empty( $response->results ) ) {
			return $out;
		}
		$response = reset( $response->results );

		if ( empty( $response->geometry->location->lat ) || empty( $response->geometry->location->lng ) ) {
			return $out;
		}

		return (object) array(
			'success' => true,
			'lat'     => (float) $response->geometry->location->lat,
			'lng'     => (float) $response->geometry->location->lng,
			'approx'  => ! empty( $response->geometry->location_type ) && $response->geometry->location_type === 'APPROXIMATE',
		);
	}

	// Open Street Map
	$response = wp_remote_get( 'https://nominatim.openstreetmap.org/search?format=json&q=' . $address );

	if (  is_wp_error( $response ) ) {
		return $out;
	}

	$response = json_decode( wp_remote_retrieve_body( $response ) );

	if ( empty( $response ) ) {
		return $out;
	}

	$response = reset( $response );

	if ( empty( $response->lat ) || empty( $response->lon ) ) {
		return $out;
	}

	return (object) array(
		'success' => true,
		'lat'     => (float) $response->lat,
		'lng'     => (float) $response->lon,
		'approx'  => null,
	);
}

endif;


/*-----------------------------------------------------------------------------------*/
/* !Tools ========================================================================== */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'noop_send_json' ) ) :

function noop_send_json( $response ) {
	if ( function_exists( 'wp_send_json' ) ) {
		wp_send_json( $response );
	}

	@header( 'Content-Type: application/json; charset=' . get_option( 'blog_charset' ) );
	echo json_encode( $response );
	if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
		wp_die();
	}
	die;
}

endif;


if ( ! function_exists( 'noop_send_json_error' ) ) :

function noop_send_json_error( $data = null ) {
	if ( function_exists( 'wp_send_json_error' ) ) {
		wp_send_json_error( $data );
	}

	$response = array( 'success' => false );

	if ( isset( $data ) ) {
		$response['data'] = $data;
	}

	noop_send_json( $response );
}

endif;


if ( ! function_exists( 'noop_send_json_success' ) ) :

function noop_send_json_success( $data = null ) {
	if ( function_exists( 'wp_send_json_success' ) ) {
		wp_send_json_success( $data );
	}

	$response = array( 'success' => true );

	if ( isset( $data ) ) {
		$response['data'] = $data;
	}

	noop_send_json( $response );
}

endif;
