<?php
/*
 * Plugin Name: Noop
 * Plugin URI: https://www.screenfeed.fr
 * Description: Noop is a framework to use within other plugins or themes, it does nothing by itself. It's aim is to provide a secure and robust foundation, and also powerful tools, to build great settings pages and manage options.
 * Version: 1.1.9
 * Author: Grégory Viguier
 * Author URI: https://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: https://www.screenfeed.fr/gpl-v3.txt
 * Text Domain: noop
 * Domain Path: /languages
 * Provides: Noop
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

// 3.3+: All is OK. 3.1+: OK but tinyMCE won't work (too lazy to fallback to the old editor).
if ( version_compare( $GLOBALS['wp_version'], '3.1', '<' ) ) {
	return;
}

define( 'NOOP_VERSION', '1.1.9' );
define( 'NOOP_FILE',    __FILE__ );
define( 'NOOP_DIR',     plugin_dir_path( NOOP_FILE ) );
define( 'NOOP_URL',     plugin_dir_url( NOOP_FILE ) );

if ( is_admin() ) {
	// Updater
	if ( ! function_exists( 'sf_updater_check_update' ) ) {
		include( NOOP_DIR . 'inc/updater.inc.php' );
	}

	add_filter( 'sf_plugins_updates', 'noop_update' );

	function noop_update( $plugins = array() ) {
		$plugins[ NOOP_FILE ] = NOOP_VERSION;
		return $plugins;
	}
}
