// Unify gmaps and osm
var noopMap = {
	// Shorthand
	getEl: function( id ) {
		return document.getElementById( id );
	},

	// Set latitude and longitude into "lato" and "lngo" fields, display a green "OK" message, open the left sub-panel, and display the map
	setLatLng: function( m, result ) {
		var lato		= this.getEl( m.prefix + "-lato" ),
			lngo		= this.getEl( m.prefix + "-lngo" ),
			errcnt		= this.getEl( m.prefix + "-geo-msg" );

		lato.value	= result.lat;
		lngo.value	= result.lng;

		errcnt.style.display = "inline-block";
		errcnt.style.color = "green";
		errcnt.innerHTML = "OK!";
		jQuery( this.getEl( m.prefix + "-show-map" ) ).removeClass("hidden").trigger("click").next(".empty-map").removeClass("hidden");
	},

	// Display an error message
	errorMsg: function( m, msg ) {
		var errcnt		= this.getEl( m.prefix + "-geo-msg" );

		errcnt.style.display = "block";
		errcnt.style.color = "red";
		errcnt.innerHTML = msg;
	},

	// !Geocode the address
	getCoords: function (m ) {
		var data = {
				action:			"noop_geoloc_address",
				_ajax_nonce:	this.getEl( "noop-geoloc-address-nonce" ).value,
				address:		""
			},
			adr_nogeo		= this.getEl( m.address + "_nogeo" ),
			adr_2_nogeo		= this.getEl( m.address_2 + "_nogeo" ),
			state			= this.getEl( m.state ),
			zip				= this.getEl( m.zip ),
			city			= this.getEl( m.city ),
			country			= this.getEl( m.country ),
			tmp;

		if ( adr_nogeo === null || ! adr_nogeo.checked ) {
			tmp				= this.getEl( m.address );
			data.address	= tmp !== null		&& tmp.value.length		? tmp.value : "";
		}
		if ( adr_2_nogeo === null || ! adr_2_nogeo.checked ) {
			tmp				= this.getEl( m.address_2 );
			data.address	+= tmp !== null		&& tmp.value.length		? ( data.address ? "," : "" ) + tmp.value : "";
		}
		data.address		+= state !== null	&& state.value.length	? ( data.address ? "," : "" ) + state.value : "";
		data.address		+= zip !== null		&& zip.value.length		? ( data.address ? "," : "" ) + zip.value : "";
		data.address		+= city !== null	&& city.value.length	? ( data.address ? "," : "" ) + city.value : "";
		data.address		+= country !== null	&& country.value.length	? ( data.address ? "," : "" ) + country.value : "";

		if ( data.address ) {
			jQuery.ajax( window.ajaxurl, {
				type: "POST",
				data: data,
				dataType: "json"
			})
			.done( function( x ) {
				if ( typeof x !== "object" ) {
					noopMap.errorMsg( m, window.mapl10n.error );
				}
				else if ( ! x.success || ! x.data.success ) {
					noopMap.errorMsg( m, window.mapl10n.not_found );
				}
				else {
					noopMap.setLatLng( m, x.data );
				}
			})
			.fail( function() {
				noopMap.errorMsg( m, window.mapl10n.error );
			});
		}
		else {
			noopMap.errorMsg( m, window.mapl10n.error );
		}
	},

	// Build a LatLng object
	LatLng: function( m, lat, lng ) {
		if ( ! m.source || m.source === "gmaps" ) {
			return new window.google.maps.LatLng( lat, lng );
		}
		else if ( m.source === "osm" ) {
			return new window.L.LatLng( lat, lng );
		}
	},

	// Build a map
	map: function( m ) {
		var opt = {
			center:		m.center,
			zoom:		m.zoomval,
			minZoom:	2,
			maxZoom:	18
		};
		if ( ! m.source || m.source === "gmaps" ) {
			opt.mapTypeId	= window.google.maps.MapTypeId.ROADMAP;
			opt.panControl	= false;
			opt.maxZoom		= 20;
			opt.scrollwheel	= false;
			return new window.google.maps.Map( m.div, opt );
		}
		else if ( m.source === "osm" ) {
			// Map
			m.map = window.L.map( m.div, opt );
			// Copyrights
			window.L.tileLayer( m.tileLayer, {
				attribution: 'Data &copy; <a href="https://www.openstreetmap.org">OpenStreetMap</a> contributors, <a href="https://www.openstreetmap.org/copyright">ODbL 1.0.</a>'
			} ).addTo( m.map );
			// Scale Control
			window.L.control.scale().addTo(m.map);
			// Disable zoom with mouse wheel
			m.map.scrollWheelZoom.disable();
			return m.map;
		}
	},

	// Build a marker and add it to the map
	marker: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			m.marker	= new window.google.maps.Marker( { position: m.markerPos, map: m.map, draggable: true } );
			if ( typeof window.mapl10n.icon !== "undefined" ) {
				m.marker.setIcon( window.mapl10n.icon );
			}
			return m.marker;
		}
		else if ( m.source === "osm" ) {
			return window.L.marker( m.markerPos, { draggable: true } ).addTo( m.map );
		}
	},

	// Left sub-panel: refresh the marker Lat/Lng values on move
	displayMarkerPosOnMove: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			window.google.maps.event.addListener( m.marker, "position_changed", function() {
				m.markerPos  = m.marker.getPosition();
				m.mlat.value = m.markerPos.lat();
				m.mlng.value = m.markerPos.lng();
			});
		}
		else if ( m.source === "osm" ) {
			m.marker.on( "drag move", function() {
				m.markerPos  = m.marker.getLatLng();
				m.mlat.value = m.markerPos.lat;
				m.mlng.value = m.markerPos.lng;
			});
		}
		return m;
	},

	// Left sub-panel: refresh the map Lat/Lng values on move (center)
	displayMapCenterOnMove: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			window.google.maps.event.addListener( m.map, "center_changed", function() {
				m.center = m.map.getCenter();
				m.clat.value = m.center.lat();
				m.clng.value = m.center.lng();
			});
		}
		else if ( m.source === "osm" ) {
			m.map.on( "move", function() {
				m.center = m.map.getCenter();
				m.clat.value = m.center.lat;
				m.clng.value = m.center.lng;
			});
		}
		return m;
	},

	// Left sub-panel: refresh the map zoom value on change
	displayZoomValueOnChange: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			window.google.maps.event.addListener( m.map, "zoom_changed", function() {
				m.mzoom.value = m.map.getZoom();
			});
		}
		else if ( m.source === "osm" ) {
			m.map.on( "zoomend",function() {
				m.mzoom.value = m.map.getZoom();
			});
		}
		return m;
	},

	// Refresh the map with new center, zoom, and marker position
	refreshMap: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			m.map.panTo( m.center );
			m.map.setZoom( m.zoomval );
			m.marker.setPosition( m.markerPos );
		}
		else if ( m.source === "osm" ) {
			m.marker.setLatLng( m.markerPos );
			m.map.setView( m.center, m.zoomval );
		}
		return m;
	},

	// Destroy the map
	destroy: function( m ) {
		if ( ! m.source || m.source === "gmaps" ) {
			m.map.unbindAll();
		}
		else if ( m.source === "osm" ) {
			m.map.remove();
		}
		m.marker = null;
		m.map = null;
		jQuery( m.div ).empty();
		return m;
	},

	// Display the map
	showMap: function( m ) {
		m.latoval	= m.lato.value.length ? parseFloat( m.lato.value )   : 0;
		m.lngoval	= m.lngo.value.length ? parseFloat( m.lngo.value )   : 0;
		m.latval	= m.lat.value.length  ? parseFloat( m.lat.value )    : m.latoval;
		m.lngval	= m.lng.value.length  ? parseFloat( m.lng.value )    : m.lngoval;
		m.latcval	= m.latc.value.length ? parseFloat( m.latc.value )   : m.latval;
		m.lngcval	= m.lngc.value.length ? parseFloat( m.lngc.value )   : m.lngval;
		m.zoomval	= m.zoom.value.length ? parseInt( m.zoom.value, 10 ) : 15;

		if ( ! m.latval || ! m.lngval ) {
			return false;
		}

		m.center	= this.LatLng( m, m.latcval, m.lngcval );	// Center
		m.markerPos	= this.LatLng( m, m.latval, m.lngval );		// Marker

		if ( ! m.map || jQuery( m.infos ).hasClass("hidden") ) {
			jQuery( m.div )
				.css( "height", function() { return Math.floor( jQuery( m.coordsDiv ).outerHeight(false) ) + "px"; } )
				.animate( { width: "50%", marginRight: "2%" }, "normal", function() {
					// Map
					m.map = noopMap.map( m );
					// Add the marker
					m.marker = noopMap.marker( m );

					// Events
					noopMap.displayMarkerPosOnMove( m );

					noopMap.displayMapCenterOnMove( m );

					noopMap.displayZoomValueOnChange( m );
				} );

			m.mlat.value  = m.latval;
			m.mlng.value  = m.lngval;
			m.clat.value  = m.latcval;
			m.clng.value  = m.lngcval;
			m.mzoom.value = m.zoomval;
			jQuery( m.infos ).removeClass("hidden");
		}
		else {
			this.refreshMap( m );
		}
	}
};



jQuery(document).ready(function($){

	if ( window.maps && window.mapl10n ) {
		$.each( window.maps, function( i, m ) {
			m.map		= false;
			m.marker	= false;
			// Boxes
			m.infos		= noopMap.getEl( m.prefix + "-map-infos" );
			m.div		= noopMap.getEl( m.prefix + "-map" );
			m.coordsDiv	= noopMap.getEl( m.prefix + "-map-coords" );
			// Fields
			m.lato		= noopMap.getEl( m.prefix + "-lato" );
			m.lngo		= noopMap.getEl( m.prefix + "-lngo" );
			m.lat		= noopMap.getEl( m.prefix + "-lat" );
			m.lng		= noopMap.getEl( m.prefix + "-lng" );
			m.latc		= noopMap.getEl( m.prefix + "-latc" );
			m.lngc		= noopMap.getEl( m.prefix + "-lngc" );
			m.zoom		= noopMap.getEl( m.prefix + "-zoom" );
			// Left infos panel
			m.mlat		= noopMap.getEl( m.prefix + "-marker-lat" );
			m.mlng		= noopMap.getEl( m.prefix + "-marker-lng" );
			m.clat		= noopMap.getEl( m.prefix + "-center-lat" );
			m.clng		= noopMap.getEl( m.prefix + "-center-lng" );
			m.mzoom		= noopMap.getEl( m.prefix + "-map-zoom" );

			$( m.coordsDiv )
				.on( "click", ".get-coords", function( e ) {
					noopMap.getCoords( m );
				} )
				.on( "click", ".show-map", function( e ) {
					noopMap.showMap( m );
				} )
				.on( "click", ".empty-map", function( e ) {
					var $this = $(this).addClass("hidden"),
						$wrap = $this.parents(".map-wrap");
					if ( m.map ) {
						noopMap.destroy( m );
					}
					$this.siblings(".show-map").addClass("hidden");
					$wrap.children(".map-infos").addClass("hidden");
					$wrap.children(".map").removeAttr("style");
					$wrap.find( '[type="text"], [type="number"]' ).prop( "value", "" ).filter( ".zoom" ).prop( "value", function() {
						var def = $(this).data("def-zoom");
						def = typeof def === "undefined" ? "" : parseInt( def, 10 );
						return def ? def : "";
					} );
				} );

			$( m.infos )
				.on( "click", ".marker-send", function( e ) {
					m.lat.value = m.mlat.value;
					m.lng.value = m.mlng.value;
				} )
				.on( "click", ".center-send", function( e ) {
					m.latc.value = m.clat.value;
					m.lngc.value = m.clng.value;
				} )
				.on( "click", ".zoom-send", function( e ) {
					m.zoom.value = m.mzoom.value;
				} );

			if ( m.lato.value && m.lngo.value ) {
				$( noopMap.getEl( m.prefix + "-show-map" ) ).removeClass("hidden").trigger("click").next(".empty-map").removeClass("hidden");
			}
		});
	}

});
