<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

// !Select user
if ( ! function_exists( 'noop_select_user_field' ) ) :

function noop_select_user_field( $o ) {
	if ( ( empty( $o['label_for'] ) && empty( $o['name'] ) ) || empty( $o['option_name'] ) ) {
		return;
	}

	$o = array_merge( array(
		'label_for'        => '',		// (1)
		'name'             => '',		// (1)
		'label'            => '',
		'value'            => null,

		'class'            => '',

		'order'            => 'ASC',				// 'DESC', 'ASC'
		'orderby'          => 'display_name',		// 'ID', 'user_nicename', 'display_name'
		'include'          => '',					// Comma separated list of users IDs to include
		'exclude'          => '',					// Comma separated list of users IDs to exclude
		'show'             => 'display_name',		// 'ID', 'user_login', 'display_name'
		'include_selected' => false,
		'show_option_all'  => '',					// 'All Users'
		'show_option_none' => '',					// '&mdash; Select &mdash;'
		'blog_id'          => $GLOBALS['blog_id'],
		'who'              => '',					// 'authors'
	), $o );

	$o['id']   = $o['label_for'] ? $o['label_for'] : $o['name'];
	$o['name'] = $o['name'] ? $o['name'] : $o['id'];
	$name      = $o['name'];			// Store this for the description/default value

	if ( is_null( $o['value'] ) ) {
		if ( false !== strpos( $name, '|' ) ) {
			$exploded_name = explode( '|', $name );
			$o['selected'] = Noop_Fields::get_deep_array_val( $o['options'], $exploded_name );
		} else {
			$o['selected'] = $o['options'][ $name ];
		}
	} else {
		$o['selected'] = $o['value'];
	}

	$o['name'] = $o['option_name'] . ( ! empty( $o['locales']['locale'] ) ? '[' . $o['locales']['locale'] . ']' : '' ) . '[' . str_replace( '|', '][', $o['name'] ) . ']';

	$o['show_option_all']  = ( 'all' === $o['show_option_all'] || 'all users' === $o['show_option_all'] ) ? __( 'All Users' ) : $o['show_option_all'];
	$o['show_option_none'] = ( 'choose' === $o['show_option_none'] || 'select' === $o['show_option_none'] ) ? __( '&mdash; Select &mdash;' ) : $o['show_option_none'];

	echo "\t\t\t\t";
	echo $o['label'] ? '<label for="' . $o['id'] . '">' . $o['label'] . '</label> ' : '';

	wp_dropdown_users( $o );

	// Prepare for the default values
	$o['name'] = $name;
	if ( ! empty( $o['default'] ) && $user = get_userdata( $o['default'] ) ) {
		$o['values'][ $user->ID ] = esc_html( ! empty( $user->$o['show'] ) ? $user->$o['show'] : $user->user_login );
	}
	elseif ( ! empty( $o['defaults'] ) ) {
		if ( false !== strpos( $name, '|' ) ) {
			$exploded_name = explode( '|', $name );
			$default = Noop_Fields::get_deep_array_val( $o['defaults'], $exploded_name );

			if ( -1 === $default || ! $default ) {
				$o['defaults'] = Noop_Fields::set_deep_array_val( 0, $exploded_name, $o['defaults'] );
			}
			elseif ( $default && $user = get_userdata( $default ) ) {
				$val             = esc_html( ! empty( $user->$o['show'] ) ? $user->$o['show'] : $user->user_login );
				$exploded_name[] = $user->ID;
				$o['values']     = Noop_Fields::set_deep_array_val( $val, $exploded_name, $o['values'] );
			}
		} else {
			if ( empty( $o['defaults'][ $name ] ) || -1 === $o['defaults'][ $name ] ) {
				$o['defaults'][ $name ] = 0;
			} elseif ( ! empty( $o['defaults'][ $name ] ) && $user = get_userdata( $o['defaults'][ $name ] ) ) {
				$o['values'][ $user->ID ] = esc_html( ! empty( $user->$o['show'] ) ? $user->$o['show'] : $user->user_login );
			}
		}
	}

	echo Noop_Fields::get_instance( $o['option_name'] )->default_and_description( $o );
}

endif;
