<?php
function add_my_themes()
{
    wp_admin_css_color( 'red', _x( 'Cherry', 'admin color scheme' ), get_template_directory_uri() . '/css/red.css', array( '#aa5555', '#e9cfcf', '#eed1d1', '#ffefef' ) );
	remove_admin_css_color( 'fresh' );
}
add_action( 'admin_init', 'add_my_themes', 1 );

function remove_admin_css_color( $theme )
{
    global $_wp_admin_css_colors;
    if ( isset( $_wp_admin_css_colors[$theme] ) )
        unset( $_wp_admin_css_colors[$theme ] );
}

remove_action( 'admin_color_scheme_picker', 'admin_color_scheme_picker' );

function my_admin_color_scheme_picker() {
    global $_wp_admin_css_colors, $user_id; ?>
<fieldset><legend class="screen-reader-text"><span><?php _e('Admin Color Scheme')?></span></legend>
<?php
$current_color = get_user_option('admin_color', $user_id);
if ( empty($current_color) )
    $current_color = 'fresh';
foreach ( $_wp_admin_css_colors as $color => $color_info ): ?>
<div class="color-option"><input name="admin_color" id="admin_color_<?php echo $color; ?>" type="radio" value="<?php echo esc_attr($color) ?>" class="tog" <?php checked($color, $current_color); ?> />
    <table class="color-palette">
    <tr>
    <?php foreach ( $color_info->colors as $html_color ): ?>
    <td style="background-color: <?php echo $html_color ?>; border-radius: 20px; width: 16px" title="<?php echo $color ?>">&nbsp;</td>
    <?php endforeach; ?>
    </tr>
    </table>
 
    <label for="admin_color_<?php echo $color; ?>"><?php echo $color_info->name ?></label>
</div>
    <?php endforeach; ?>
</fieldset>
<?php
}
add_action( 'admin_color_scheme_picker', 'my_admin_color_scheme_picker' ); // commenter si vous forcez un thme

// add_filter( 'get_user_option_admin_color', create_function( "", "return 'red';" ) ); // dcommenter pour forcer un thme (ici le rouge)

?>