<?php

namespace Screenfeed\AdminbarTools\Dependencies\League\Container;

trait ContainerAwareTrait
{
    /**
     * @var \Screenfeed\AdminbarTools\Dependencies\League\Container\ContainerInterface
     */
    protected $container;

    /**
     * Set a container.
     *
     * @param  \Screenfeed\AdminbarTools\Dependencies\League\Container\ContainerInterface $container
     * @return $this
     */
    public function setContainer(ContainerInterface $container)
    {
        $this->container = $container;

        return $this;
    }

    /**
     * Get the container.
     *
     * @return \Screenfeed\AdminbarTools\Dependencies\League\Container\ContainerInterface
     */
    public function getContainer()
    {
        return $this->container;
    }
}
