<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

/*-----------------------------------------------------------------------------------*/
/* !TOOLS. ========================================================================= */
/*-----------------------------------------------------------------------------------*/

/*
 * Get a regex, build with the URLs of WordPress directories (like current theme, plugins, wp-includes), to ckeck if a given URL starts with one of those URLs.
 *
 * @return (string) regex to test an URL against.
 */

function sfbc_get_default_scripts_directories() {
	static $regex;

	if ( ! isset( $regex ) ) {
		// An array containing URLs.
		$urls = array_unique( apply_filters( 'sfbc_default_scripts_directories', array(
			get_stylesheet_directory_uri() . '/',
			get_template_directory_uri() . '/',
			plugins_url( '/' ),
			plugins_url( '/', WPMU_PLUGIN_DIR . '/my-poney-is-fat' ),
			includes_url(),
		) ) );
		foreach( $urls as $i => $url ) {
			$urls[ $i ] = preg_replace( '|^(https?:)?//|', '', $url );
		}
		$regex = str_replace( '.', '\.', '@^(https?:)?//(' . implode( '|', $urls ) . ')@' );
	}

	return $regex;
}


/*
 * Transform an URL like <code>http://example.com/some-script.js</code> to <code>http://example.com/some-script.102.js</code>.
 *
 * @param  (string) $src  A CSS or JS URL.
 * @param  (string) $ver  The version to insert in the URL.
 * @param  (string) $type Two values: "js" or "css".
 * @return The (maybe) modified URL.
 */

function sfbc_build_src_for_cache_busting( $src, $ver, $type = 'js' ) {
	$ext = $type === 'js' ? '.js' : '.css';

	if ( $pos = strrpos( $src, $ext ) ) {

		// Make sure the script is local.
		$regex = sfbc_get_default_scripts_directories();

		if ( preg_match( $regex, $src ) ) {
			$ref = $type === 'js' ? 'wp_scripts' : 'wp_styles';
			$def = ! empty( $GLOBALS[ $ref ] ) ? $GLOBALS[ $ref ]->default_version : get_bloginfo( 'version' );		// In case this function is used "outside" the plugin, the global var may not be set yet.
			$ver = ! empty( $ver ) ? $ver : $def;
			$ver = str_replace( array( 'alpha', 'beta', 'RC' ), array( '1121681', '25201', '183' ), $ver );
			$ver = preg_replace( '@[^\d]@', '0', $ver );
			$src = substr_replace( $src, '.' . $ver . $ext, $pos );
		}

	}

	return $src;
}

/*-----------------------------------------------------------------------------------*/
/* !HOOKS. ========================================================================= */
/*-----------------------------------------------------------------------------------*/

/*
 * Filter the styles/scripts URL.
 *
 * @param  (string) $src    A CSS or JS URL.
 * @param  (string) $handle The script name.
 * @return The URL.
 */

add_filter( 'style_loader_src',  'sfcb_cache_busting_loader_src', 2, 2 );
add_filter( 'script_loader_src', 'sfcb_cache_busting_loader_src', 2, 2 );

function sfcb_cache_busting_loader_src( $src, $handle ) {
	if ( current_filter() === 'script_loader_src' ) {
		$ref  = 'wp_scripts';
		$type = 'js';
	}
	else {
		$ref  = 'wp_styles';
		$type = 'css';
	}

	if ( empty( $src ) || empty( $GLOBALS[ $ref ]->registered[ $handle ] ) ) {
		return $src;
	}

	$src = sfbc_build_src_for_cache_busting( $src, $GLOBALS[ $ref ]->registered[ $handle ]->ver, $type );
	$GLOBALS[ $ref ]->registered[ $handle ]->src = $src;

	return $src;
}


/**/