<?php
/*
 * Plugin Name: SF Cache Busting
 * Plugin URI: http://www.screenfeed.fr
 * Description: Change your CSS and JavaScript files URL from <code>some-script.js?ver=1.2</code> to <code>some-script.102.js</code>, to allow proxies to correctly cache those files, and so, decrease page load time.
 * Version: 1.0
 * Author: Grégory Viguier
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt

Before activating this plugin, put the following in your <code>.htaccess</code> file, BEFORE the WordPress rewrite rules:

<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^(.+)\.(\d+)\.(css|js)$ $1.$3 [L]
</IfModule>

If you don't already have added Expires HTTP response header, you can use the following:

<IfModule mod_expires.c>
    ExpiresActive on
    ExpiresByType text/css                "access plus 1 year"
    ExpiresByType application/javascript  "access plus 1 year"
</IfModule>

 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}


define( 'SFCB_VERSION', '1.0' );


if ( ! defined( 'XMLRPC_REQUEST' ) && ! defined( 'DOING_CRON' ) && ! is_admin() ) {
	include( plugin_dir_path( __FILE__ ) . 'inc/frontend.php' );
}

/**/