<?php
/*
 * Plugin Name: SF Owner Role
 * Plugin URI: http://www.screenfeed.fr
 * Description: Creates the User Role "Owner".
 * Version: 1.2
 * Author: GregLone
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt
*/

if( !defined( 'ABSPATH' ) )
	die( 'Cheatin\' uh?' );

/* !---------------------------------------------------------------------------------*/
/* !	I18N																		 */
/*-----------------------------------------------------------------------------------*/

add_action( 'init', 'sfor_lang_init' );

function sfor_lang_init() {
	load_plugin_textdomain( 'default', false, basename( dirname( __FILE__ ) ) . '/languages' );
}


/* !---------------------------------------------------------------------------------*/
/* !	CREATE THE NEW ROLE															 */
/*-----------------------------------------------------------------------------------*/

function sfor_create_role() {
	// Creates a Owner User Role (editor level, with super-powers)
	if ( $editor = get_role('editor') ) {
		remove_role( 'owner' );
		add_role( 'owner', 'Owner', $editor->capabilities );

		$owner = get_role('owner');
		// Can manipulate users
		$owner->add_cap( 'list_users' );
		$owner->add_cap( 'create_users' );
		$owner->add_cap( 'edit_users' );
		$owner->add_cap( 'promote_users' );
		$owner->add_cap( 'delete_users' );
		$owner->add_cap( 'remove_users' );
		// Can edit theme options and menus
		$owner->add_cap( 'edit_theme_options' );
	}
}

register_activation_hook( __FILE__, 'sfor_create_role' );
/**/