<?php
/*
 * Plugin Name: SF Restrict Medias by author
 * Plugin URI: http://www.screenfeed.fr/rmba/
 * Description: In the administration area, non-administrators can list only the medias they uploaded.
 * Version: 1.0
 * Author: Grégory Viguier
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt
 */

if( !defined( 'ABSPATH' ) )
	die( 'Cheatin\' uh?' );

if ( !is_admin() )
	return;


// !Control who can see all Medias

function rmba_can_see_medias() {
	static $can;
	if ( !$can ) {
		$can = apply_filters( 'rmba_can_see_medias_cap', 'edit_theme_options' );
		$can = current_user_can( $can );
	}
	return $can;
}


// !Restrict the Medias modal, Medias list table

add_filter('parse_query', 'rmba_restrict_medias_by_author');
function rmba_restrict_medias_by_author( $query ) {
	if ( ( (isset($_POST['action']) && $_POST['action'] == 'query-attachments') || (isset($query->query_vars['post_type']) && $query->query_vars['post_type'] == 'attachment') ) && !rmba_can_see_medias() ) {
		$query->set( 'author', get_current_user_id() );
	}
}


// !Restrict the Media edit page. WP should already block the user... Just in case.

add_action( 'admin_enqueue_scripts', 'rmba_attachment_edit_restrict_by_author' );
function rmba_attachment_edit_restrict_by_author( $r ) {
	global $post, $pagenow, $typenow;
	if ( !rmba_can_see_medias() && $pagenow == 'post.php' && $typenow == 'attachment' && $post->post_type == 'attachment' && $post->post_author != get_current_user_id() ) {
		wp_die(__('You are not allowed to edit this item.'));
	}
}


// !The filters at the top of the Medias list table: update the items/numbers for the current user.

add_filter( 'views_upload', 'rmba_attachments_list_views_for_author', 8 );
function rmba_attachments_list_views_for_author( $views ) {
	if ( rmba_can_see_medias() )
		return $views;

	global $wpdb, $post_mime_types, $avail_post_mime_types, $wp_list_table;

	$type_links		= array();
	$user_ID		= get_current_user_id();
	$_num_posts		= (array) rmba_count_author_attachments();
	$_total_posts	= array_sum($_num_posts) - $_num_posts['trash'];
	$total_orphans	= $wpdb->get_var( "SELECT COUNT( ID ) FROM $wpdb->posts WHERE post_type = 'attachment' AND post_status != 'trash' AND post_parent < 1 AND post_author = $user_ID" );
	$matches		= wp_match_mime_types(array_keys($post_mime_types), array_keys($_num_posts));

	foreach ( $matches as $type => $reals )
		foreach ( $reals as $real )
			$num_posts[$type] = ( isset( $num_posts[$type] ) ) ? $num_posts[$type] + $_num_posts[$real] : $_num_posts[$real];

	$class = ( empty($_GET['post_mime_type']) && !$wp_list_table->detached && !isset($_GET['status']) ) ? ' class="current"' : '';
	$type_links['all'] = '<a href="upload.php"'.$class.'>' . sprintf( _nx( 'All <span class="count">(%s)</span>', 'All <span class="count">(%s)</span>', $_total_posts, 'uploaded files' ), number_format_i18n( $_total_posts ) ) . '</a>';
	foreach ( $post_mime_types as $mime_type => $label ) {
		$class = '';

		if ( !wp_match_mime_types($mime_type, $avail_post_mime_types) )
			continue;

		if ( !empty($_GET['post_mime_type']) && wp_match_mime_types($mime_type, $_GET['post_mime_type']) )
			$class = ' class="current"';
		if ( !empty( $num_posts[$mime_type] ) )
			$type_links[$mime_type] = '<a href="upload.php?post_mime_type='.$mime_type.'"'.$class.'>' . sprintf( translate_nooped_plural( $label[2], $num_posts[$mime_type] ), number_format_i18n( $num_posts[$mime_type] )) . '</a>';
	}
	$type_links['detached'] = '<a href="upload.php?detached=1"' . ( $wp_list_table->detached ? ' class="current"' : '' ) . '>' . sprintf( _nx( 'Unattached <span class="count">(%s)</span>', 'Unattached <span class="count">(%s)</span>', $total_orphans, 'detached files' ), number_format_i18n( $total_orphans ) ) . '</a>';

	if ( !empty($_num_posts['trash']) )
		$type_links['trash'] = '<a href="upload.php?status=trash"' . ( (isset($_GET['status']) && $_GET['status'] == 'trash' ) ? ' class="current"' : '') . '>' . sprintf( _nx( 'Trash <span class="count">(%s)</span>', 'Trash <span class="count">(%s)</span>', $_num_posts['trash'], 'uploaded files' ), number_format_i18n( $_num_posts['trash'] ) ) . '</a>';

	return array_merge($views, $type_links);
}


function rmba_count_author_attachments( $mime_type = '' ) {
	global $wpdb;

	$and		= wp_post_mime_type_where( $mime_type );
	$user_ID	= get_current_user_id();
	$count		= $wpdb->get_results( "SELECT post_mime_type, COUNT( ID ) AS num_posts FROM $wpdb->posts WHERE post_type = 'attachment' AND post_status != 'trash' AND post_author = $user_ID $and GROUP BY post_mime_type", ARRAY_A );
	$counts		= array();

	foreach( (array) $count as $row ) {
		$counts[ $row['post_mime_type'] ] = $row['num_posts'];
	}
	$counts['trash'] = $wpdb->get_var( "SELECT COUNT( ID ) FROM $wpdb->posts WHERE post_type = 'attachment' AND post_status = 'trash' AND post_author = $user_ID $and");

	/**
	 * Modify returned attachment counts by mime type.
	 *
	 * @since 3.7.0
	 *
	 * @param object $counts    An object containing the attachment counts by mime type.
	 * @param string $mime_type The mime type pattern used to filter the attachments counted.
	 */
	return apply_filters( 'wp_count_attachments', (object) $counts, $mime_type );
}

/**/