<?php
/*
 * Plugin Name: SF Roles Reset
 * Plugin URI: http://www.screenfeed.fr
 * Description: Reset user roles when you activate this plugin. For a multisite installation you can define the constants <code>RESET_ROLES_FOR_BLOGS</code> or <code>RESET_ROLES_NOT_FOR_BLOGS</code> to customize the blogs list.
 * Version: 1.0
 * Author: Grégory Viguier
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt
 */

if( !defined( 'ABSPATH' ) )
	die( 'Cheatin\' uh?' );

if ( !is_admin() )
	return;


function sfrr_reset_roles() {
	if ( is_network_admin() ) {
		// Only for these blogs
		if ( defined( 'RESET_ROLES_FOR_BLOGS' ) && RESET_ROLES_FOR_BLOGS ) {
			$blogs = array_filter( wp_parse_id_list( RESET_ROLES_FOR_BLOGS ) );
		}
		// All blogs
		else {
			global $wpdb;
			$query = "SELECT blog_id FROM $wpdb->blogs WHERE site_id = %d";

			// Exclude some blogs
			$not_blogs = '';
			if ( defined( 'RESET_ROLES_NOT_FOR_BLOGS' ) && RESET_ROLES_NOT_FOR_BLOGS ) {
				$not_blogs = array_filter( wp_parse_id_list( RESET_ROLES_NOT_FOR_BLOGS ) );
				$not_blogs = implode( ',', $not_blogs );
				$query .= " AND blog_id NOT IN (%s)";
			}

			$blogs = $wpdb->get_col( $wpdb->prepare( $query, $wpdb->siteid, $not_blogs ) );
		}
		if ( !empty( $blogs ) ) {
			foreach ( $blogs as $blog_id ) {
				switch_to_blog( (int) $blog_id );
				sfrr_reset_roles_for_blog();
				restore_current_blog();
			}
		}
	}
	else {
		sfrr_reset_roles_for_blog();
	}
}


function sfrr_reset_roles_for_blog() {
	$roles = new WP_Roles();

	// Remove all existing roles
	$roles = array_keys( $roles->get_names() );
	array_map( 'remove_role', $roles );

	// Create initial roles
	if ( !function_exists('populate_roles') ) {
		require_once( path_join(ABSPATH, 'wp-admin/includes/schema.php') );
	}
	populate_roles();
}


register_activation_hook( __FILE__, 'sfrr_reset_roles' );
/**/