<?php

/* Language support */
function sf_smilies_lang_init() {
	load_plugin_textdomain( 'sf-smilies', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}


/* Settings for the administration page */
function sf_smilies_register_settings() {
	register_setting( 'sf-smilies-settings', 'sf_smilies_options' );
	register_setting( 'sf-smilies-settings', 'sf-smilies-error' );
	register_setting( 'sf-smilies-settings', 'use_smilies' );
}


/* For activation hook */
function sf_smilies_default_values($action) {
	$tmp = get_option('sf_smilies_options');

	if ( !isset($tmp['db_version']) || (isset($tmp['db_version']) && $tmp['db_version'] != SF_SMILIES_DB_VERSION) || !is_array($tmp) || $action == 'raz' ) {
		delete_option('sf_smilies_options');
		$deficons = array(
			 0 => array('name' => 'icon_biggrin'  , 'disp' => 1, 'symb' => ':D'),
			 1 => array('name' => 'icon_lol'      , 'disp' => 1, 'symb' => ':lol:'),
			 2 => array('name' => 'icon_smile'    , 'disp' => 1, 'symb' => ':)'),
			 3 => array('name' => 'icon_wink'     , 'disp' => 1, 'symb' => ';)'),
			 4 => array('name' => 'icon_razz'     , 'disp' => 1, 'symb' => ':P'),
			 5 => array('name' => 'icon_cool'     , 'disp' => 1, 'symb' => '8)'),
			 6 => array('name' => 'icon_rolleyes' , 'disp' => 1, 'symb' => ':roll:'),
			 7 => array('name' => 'icon_sad'      , 'disp' => 1, 'symb' => ':('),
			 8 => array('name' => 'icon_cry'      , 'disp' => 1, 'symb' => ':cry:'),
			 9 => array('name' => 'icon_redface'  , 'disp' => 1, 'symb' => ':oops:'),
			10 => array('name' => 'icon_confused' , 'disp' => 1, 'symb' => ':?'),
			11 => array('name' => 'icon_neutral'  , 'disp' => 1, 'symb' => ':|'),
			12 => array('name' => 'icon_surprised', 'disp' => 1, 'symb' => ':o'),
			13 => array('name' => 'icon_eek'      , 'disp' => 1, 'symb' => '8O'),
			14 => array('name' => 'icon_mad'      , 'disp' => 1, 'symb' => ':x'),
			15 => array('name' => 'icon_twisted'  , 'disp' => 1, 'symb' => ':twisted:'),
			16 => array('name' => 'icon_evil'     , 'disp' => 1, 'symb' => ':evil:'),
			17 => array('name' => 'icon_mrgreen'  , 'disp' => 1, 'symb' => ':mrgreen:'),
			18 => array('name' => 'icon_idea'     , 'disp' => 1, 'symb' => ':idea:'),
			19 => array('name' => 'icon_arrow'    , 'disp' => 1, 'symb' => ':arrow:'),
			20 => array('name' => 'icon_exclaim'  , 'disp' => 1, 'symb' => ':!:'),
			21 => array('name' => 'icon_question' , 'disp' => 1, 'symb' => ':?:')
		);
		$defsets = array('db_version' => SF_SMILIES_DB_VERSION, 'use_css' => 1, 'use_js' => 1, 'use_bar' => 1, 'image' => '15/original-wordpress.png/plugin', 'icons' => $deficons );
		update_option( 'sf_smilies_options', $defsets );
	}
}


/* When unistall the plugin */
function sf_smilies_uninstaller() {
	delete_option( 'sf_smilies_options' );
	delete_option( 'sf-smilies-error' );
	global $sf_smilies;
	if (isset($sf_smilies->options['del_pers'])) {
		unlink(SF_SMILIES_CONTENT_IMGS_DIR);
	}
}


/* Menu item */
function sf_smilies_menu() {
	add_submenu_page( 'options-general.php', SF_SMILIES_PLUGIN_NAME, SF_SMILIES_PLUGIN_NAME, 'manage_options', 'sf_smilies_config', 'sf_smilies_settings_page' );
}


/* Settings page */
function sf_smilies_settings_page() {
	global $wpdb, $sf_smilies;
?>
<div class="wrap" id="sf-smilies">

	<form name="sf_smilies" method="post" action="options.php">
		<div class="icon32" id="icon-options-general"></div>
		<h2><?php echo SF_SMILIES_PLUGIN_NAME; ?></h2>
		<?php settings_fields( 'sf-smilies-settings' ); ?>

		<div class="form-table">
			<div class="metabox-holder">
				<div class="postbox">
					<h3 style="cursor:default"><?php _e('Icons', 'sf-smilies'); ?></h3>
					<div class="inside">
						<br class="clear"/>

						<p>
							<label for="use_smilies">
								<input name="use_smilies" type="checkbox" id="use_smilies" value="1" <?php checked(1, get_option('use_smilies')); ?> />
								<?php _e('Convert emoticons like <code>:-)</code> and <code>:-P</code> to graphics on display'); ?>
							</label>
						</p>

						<h4><?php _e('Choose your weapon:', 'sf-smilies'); ?></h4>
						<div id="smilies-images" class="postbox" style="display:inline-block;width:auto;padding:10px 16px;margin-bottom:0;background:#F9F9F9">
							<div id="smilies-images-load">
						<?php
						$images = $pers_smilies = array();
						if (is_dir(SF_SMILIES_CONTENT_IMGS_DIR)) {
							$pers_smilies = $sf_smilies->fetch_smilies_in_dir(SF_SMILIES_CONTENT_IMGS_DIR);
						}
						if (is_dir(SF_SMILIES_PLUGIN_IMGS_DIR)) {
							$images = $sf_smilies->fetch_smilies_in_dir(SF_SMILIES_PLUGIN_IMGS_DIR);
							if (count($images)) {
								if (count($pers_smilies)) echo '<i style="display:block;padding:4px 0 0">'.__('Plugin smilies:', 'sf-smilies').'</i>';
								print_available_packs($images, SF_SMILIES_PLUGIN_IMGS_DIR, SF_SMILIES_PLUGIN_IMGS_URL, 'plugin');
							} elseif (!count($pers_smilies)) {
								_e('Error: there\'s no image in the folder(s).', 'sf-smilies');
							}
						} elseif (!count($pers_smilies)) {
							printf( __('Error: folder "%s" is missing.', 'sf-smilies'), SF_SMILIES_PLUGIN_IMGS_DIR );
						}
						if (count($pers_smilies)) {
							echo '<i style="display:block;padding:6px 0 0">'.__('Personal smilies:', 'sf-smilies').'</i>';
							print_available_packs($pers_smilies, SF_SMILIES_CONTENT_IMGS_DIR, SF_SMILIES_CONTENT_IMGS_URL, 'personal');
						} ?>
							</div>
						</div>
						<p>
							<?php $upload_file_nonce = wp_create_nonce ('sf-smilies-upload-file_general'); ?>
							<a href="media-upload.php?_wpnonce=<?php echo $upload_file_nonce; ?>&amp;type=sf_smilies_upload&amp;TB_iframe=1&amp;width=680&amp;height=300" id="sf-smilies-upload-btn" class="button thickbox" title="<?php _e('Upload a custom smilies package', 'sf-smilies'); ?>"><?php _e('Upload a custom smilies package', 'sf-smilies'); ?></a>
							<span class="help" style="margin-left:20px"></span>
						</p>
					</div>
				</div>
			</div>

			<div class="metabox-holder">
				<div class="postbox">
					<h3 style="cursor:default"><?php _e('Toolbar', 'sf-smilies'); ?></h3>
					<div class="inside">
						<br class="clear"/>

						<p>
							<label for="sf_smilies_bar">
								<input name="sf_smilies_options[use_bar]" type="checkbox" id="sf_smilies_bar" value="1" <?php if (isset($sf_smilies->options['use_bar'])) { checked(1, $sf_smilies->options['use_bar']); } ?> />
								<?php _e('Place the toolbar in the comment form', 'sf-smilies'); ?>
							</label>
						</p>

						<h4><?php _e('Visibles icons in the toolbar:', 'sf-smilies'); ?></h4>
						<div id="smilies-bar" class="postbox" style="display:inline-block;width:auto;padding:10px 12px 10px 16px;margin-bottom:0;background:#F9F9F9">
						<?php foreach( $sf_smilies->options['icons'] as $i => $icon ) { ?>
							<label for="sf_smilies_icon<?php echo $i; ?>" class="button">
								<input name="sf_smilies_options[icons][<?php echo $i; ?>][disp]" type="checkbox" id="sf_smilies_icon<?php echo $i; ?>" value="1" <?php if (isset($icon['disp'])) { checked(1, $icon['disp']); } ?> />
								<input name="sf_smilies_options[icons][<?php echo $i; ?>][name]" type="hidden" value="<?php echo $icon['name']; ?>" />
								<input name="sf_smilies_options[icons][<?php echo $i; ?>][symb]" type="hidden" value="<?php echo $icon['symb']; ?>" />
								<span class="wp-smiley <?php echo $icon['name']; ?>" title="<?php echo $icon['symb']; ?>"><?php echo $icon['symb']; ?></span>
							</label>
						<?php } ?>
						</div>
					</div>
				</div>
			</div>

			<div class="metabox-holder meta-box-sortables">
				<div class="postbox togglable<?php if (isset($sf_smilies->options['use_css']) && isset($sf_smilies->options['use_js'])) echo ' closed'; ?>">
					<div class="handlediv" title="<?php _e('Click to toggle'); ?>"></div>
					<h3 style="cursor:pointer"><?php _e('Advanced settings', 'sf-smilies'); ?></h3>
					<div class="inside">
						<br class="clear"/>

						<p>
							<label for="sf_smilies_css">
								<input name="sf_smilies_options[use_css]" type="checkbox" id="sf_smilies_css" value="1" <?php if (isset($sf_smilies->options['use_css'])) { checked(1, $sf_smilies->options['use_css']); } ?> />
								<?php _e('Use plugin CSS style and sprite image', 'sf-smilies'); ?>
							</label>
						</p>

						<p>
							<label for="sf_smilies_js">
								<input name="sf_smilies_options[use_js]" type="checkbox" id="sf_smilies_js" value="1" <?php if (isset($sf_smilies->options['use_js'])) { checked(1, $sf_smilies->options['use_js']); } ?> />
								<?php _e('Use plugin javascript for inserting icons in the comment textarea (if you don\'t need the toobar, you can uncheck this)', 'sf-smilies'); ?>
							</label>
						</p>

						<p>
							<label for="sf_smilies_uninst">
								<input name="sf_smilies_options[del_pers]" type="checkbox" id="sf_smilies_uninst" value="1" <?php if (isset($sf_smilies->options['del_pers'])) { checked(1, $sf_smilies->options['del_pers']); } ?> />
								<?php _e('Delete my personal emoticons when I uninstall this plugin', 'sf-smilies'); ?>
							</label>
						</p>

						<p class="help"><?php _e('For more infos, look at the Help toggle at the top right of your screen.', 'sf-smilies'); ?></p>

					</div>
				</div>
			</div>

			<p class="submit">
				<input type="submit" name="submit" class="button-primary" value="<?php _e('Save Changes'); ?>" />
			</p>
		</div>
	</form>
	<?php if (file_exists(SF_SMILIES_PLUGIN_DIR.'/sf-smilies-credits.inc.php')) require_once(SF_SMILIES_PLUGIN_DIR.'/sf-smilies-credits.inc.php'); ?>
</div>
<?php
}


/* Displays rows of present images and their infos */
function print_available_packs($files = array(), $dir = SF_SMILIES_PLUGIN_IMGS_DIR, $url = SF_SMILIES_PLUGIN_IMGS_URL, $location = 'plugin') {
	global $sf_smilies;
	foreach($files as $i => $image) {
		$image = esc_html( $image );
		$imgattr = getimagesize($dir.'/'.$image);
		echo '<label for="'.$location.'-image-'.$i.'" style="line-height:'.$imgattr[1].'px;height:'.$imgattr[1].'px">';
		echo '<input id="'.$location.'-image-'.$i.'" type="radio" name="sf_smilies_options[image]" value="'.$imgattr[1].'/'.$image.'/'.$location.'" ';
		if (isset($sf_smilies->options['image'])) { if($sf_smilies->options['image'] == $imgattr[1].'/'.$image.'/'.$location) echo ' checked="checked" class="active"'; }
		echo '/> <img alt="'.$image.'" src="'.$url.'/'.$image.'" style="position:relative;top:3px;margin-right:10px"/> <span class="img-name">'.$image.'</span> - '.$imgattr[0].'x'.$imgattr[1].'px';
		echo ' <span class="delete-file" title="'.__('Delete the file', 'sf-smilies').'" rel="'.$dir.'/'.$image.'">&nbsp;</span></label><br/>';
	}
}


/* Satanize function, does nothing yet */
function sf_smilies_satanize($inputs) {
	return $inputs;
}


/* Contextual help for the Settings page */
function sf_smilies_contextual_help($help, $screen_id, $screen) {
	if ($screen_id == 'settings_page_sf_smilies_config'){
		$help  = '<h5>'.__('Icons', 'sf-smilies').'</h5>';
		$help .= '<p>'. __('<b>Convert emoticons:</b> it\'s the same option than the one in Options/Writing. Uncheck this option will disable the icons conversion.', 'sf-smilies').'<br/>';
		$help .=        __('<b>Choose your weapon:</b> if you want to add new emoticons, you need an image with the 22 emoticons side by side. Keep the same icons order, and be sure your image height is egual to each icon width and height (each icon must have same width and height, but you can use 20x20px icons if you want, your final image will be 440x20px). If one icon is missing, just leave it blank in your final custom image (or replace it with another one?).', 'sf-smilies').'</p>';
		$help .= '<h5>'.__('Toolbar', 'sf-smilies').'</h5>';
		$help .= '<p>'. __('<b>Place the toolbar in the comment form:</b> uncheck this option if you don\'t want the toolbar to be displayed right after your comment form. Otherwise, you can use <code>&lt;?php if (function_exists(\'sf_smilies_bar\')) { sf_smilies_bar(); } ?&gt;</code> anywhere in your comment form template.', 'sf-smilies').'<br/>';
		$help .=        __('<b>Visibles icons in the toolbar:</b> uncheck the smilies you don\'t want to be displayed in the toolbar. They still be generated if you insert the right code in your posts/comments.', 'sf-smilies').'</p>';
		$help .= '<h5>'.__('Advanced settings', 'sf-smilies').'</h5>';
		$help .= '<p>'. sprintf(__('<b>Use plugin CSS:</b> the icons are generated by %s. Uncheck this option to use your own CSS (the icons won\'t be generated, you will have the <code>&lt;span&gt;</code> tags only).', 'sf-smilies'), SF_SMILIES_PLUGIN_NAME).'<br/>';
		$help .=        __('<b>Use plugin javascript:</b> the toolbar needs a little bit of javascript for inserting smilies when you click on them (the script is loaded in the footer, you need <code>&lt;?php wp_footer(); ?&gt;</code> in your theme). You can uncheck this option if you prefer use your own script.', 'sf-smilies').'</p>';
		$help .= '<p><i>'.__('Nota: uncheck the CSS and javascript options won\'t disable them in the admin area.', 'sf-smilies').' <span class=\'alignright\'>'.sprintf(__('Not enough help here? Grab some on %1$smy blog%2$s [french].', 'sf-smilies'), '<a title=\'Screenfeed\' href=\'http://www.screenfeed.fr/?p=610\'>', '</a>').'</span></i></p>';
	}
	return $help;
}


/* Smilies meta box for posts/pages/custom posts editing */
function sf_smilies_meta_box() {
	if ( function_exists( 'add_meta_box' ) ) {
		$post_types = get_post_types( array('_builtin' => false) );
		$post_types['post'] = 'post';
		$post_types['page'] = 'page';
		foreach ( $post_types as $type ) {
			add_meta_box( 'sf_smilies_box', SF_SMILIES_PLUGIN_NAME,
				'sf_smilies_bar', $type,
				( function_exists( 'post_class' ) ? 'side' : 'normal' ), 'default'
			);
		}
	}
}


// Suppression d'une image
function sf_smilies_delete_img() {
	check_ajax_referer('sf-smilies-del-file_general', '_wpnonce', 'Prout!');

	if (isset($_POST['plop'])) {
		$file = str_replace( array( "\0", "%00" ), '', $_POST['plop']);
		$fh = @fopen($file, 'wb') or wp_die(__('Can\'t open file', 'sf-smilies'));
		fclose($fh);
		$valid_exts = array( 'gif', 'png' );
		$upload_ext = strtolower( substr( strrchr($file, '.') ,1) );
		if (!in_array($upload_ext,$valid_exts)) wp_die(__('Something\'s wrong, this is not a png or gif file', 'sf-smilies'));
		unlink($file);
	} else wp_die('tata');
	exit();
}


// Ajout de la fonction de l'iframe pour l'upload d'images
function sf_smilies_iframe() {
	check_ajax_referer('sf-smilies-upload-file_general', '_wpnonce', 'Prout!');

	if (isset($_FILES['img-upload'])) {

		$img = str_replace( array( "\0", "%00" ), '', $_FILES['img-upload'] );

		if ($img['error'] > 0) {			// Begening check for errors
			if     ($img['error'] == 3)			$msg = array(__('<b>Error:</b> File partialy uploaded.', 'sf-smilies'), 'error', '');											//UPLOAD_ERR_PARTIAL
			elseif ($img['error'] == 4)			$msg = array(__('<b>Error:</b> Give me some food, give me a file!', 'sf-smilies'), 'error', '');								//UPLOAD_ERR_NO_FILE
			elseif ($img['error'] == 6)			$msg = array(__('<b>Error:</b> I tried phone, fax, email, but temporary directory is unreachable.', 'sf-smilies'), 'error', '');//UPLOAD_ERR_NO_TMP_DIR
			elseif ($img['error'] == 7)			$msg = array(__('<b>Error:</b> File can\'t be written. Got a pen or something?', 'sf-smilies'), 'error', '');					//UPLOAD_ERR_CANT_WRITE
			else								$msg = array(__('<b>Error:</b> What have you done!? >_<', 'sf-smilies'), 'error', '');											//1, 2, 8
		} elseif ($img['size'] > 20480)			$msg = array(__('<b>Error:</b> File is too fat. Don\'t give him burgers!', 'sf-smilies'), 'error', 'size');						// 20ko
		else {
			$valid_exts = array( 'gif', 'png' );
			$upload_ext = strtolower( substr( strrchr($img['name'], '.') ,1) );
			if (!in_array($upload_ext,$valid_exts))							$msg = array(__('<b>Error:</b> Wrong extension. I said png and gif only!', 'sf-smilies'), 'error', 'type');	// png and gif
			else {
				$image_sizes = getimagesize($img['tmp_name']);
				if ($image_sizes[0] != 22 * $image_sizes[1])				$msg = array(__('<b>Error:</b> Wrong dimensions. Oh Gosh, need a calc?', 'sf-smilies'), 'error', 'dim');	// 22 * 1
			}
		}

		if (!isset($msg)) {					// We're good :)
			if (!file_exists(SF_SMILIES_CONTENT_IMGS_DIR))						// Check if destination folder exists. If not, we create it.
				mkdir(SF_SMILIES_CONTENT_IMGS_DIR, 0777, true);
			else
				chmod(SF_SMILIES_CONTENT_IMGS_DIR, 0777);
			$img['name'] = str_replace(' ', '_', trim($img['name']));			// We don't like space caracters
			if (file_exists(SF_SMILIES_CONTENT_IMGS_DIR.'/'.$img['name']))		// Check if file already exists. If so, we rename the new file.
				$img['name'] = date('Y-m-d_H-i-s').'_'.rand(0, 100).'_'.$img['name'];

			$sent = move_uploaded_file($img['tmp_name'], SF_SMILIES_CONTENT_IMGS_DIR.'/'.$img['name']);
			chmod(SF_SMILIES_CONTENT_IMGS_DIR.'/'.$img['name'], 0777);
			if ($sent) $msg = array(__('<b>Success:</b> Yes! You made it!', 'sf-smilies'), 'updated');
			else	   $msg = array(__('<b>Ooops!</b> Something\'s wrong, the file has not been sent :(', 'sf-smilies'), 'error');
		}
	} ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php do_action('admin_xml_ns'); ?> <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php echo get_option('blog_charset'); ?>" />
<title><?php bloginfo('name') ?> &rsaquo; <?php _e('Uploads'); ?> &#8212; <?php _e('WordPress'); ?></title>
<style type="text/css" media="all">
	html, body {width:100%;height:100%;padding:0;margin:0;}
	.blanck-head {height:0;}
	form.postbox {width: auto;padding:20px 20px 4px;margin:20px;}
	p {margin:0 0 16px;line-height:140%;}
	#ajax-loader {display:none;}
	span.error{display:inline-block;background:#ffebe8;border:solid 1px #c00;-webkit-border-radius:3px;-moz-border-radius:3px;-o-border-radius:3px;border-radius:3px;padding:3px 6px}
	form div.error{margin:5px 0 2px}
</style>
<?php wp_print_styles(array('global', 'wp-admin','colors-fresh')); ?>
</head>
<body<?php if ( isset($GLOBALS['body_id']) ) echo ' id="' . $GLOBALS['body_id'] . '"'; ?>>
	<div class="blanck-head">&nbsp;</div>
	<form id="sf-smilies-upload" class="postbox" name="sf_smilies_upload" method="post" action="media-upload.php?type=sf_smilies_upload" enctype="multipart/form-data">
		<?php wp_nonce_field('sf-smilies-upload-file_general'); ?>
		<p><b><?php _e('Upload new smilies', 'sf-smilies'); ?></b> (<?php
			if(isset($msg[2])) {												// Some UI tweaks
				if ($msg[2] == 'type') echo '<span class="error">png, gif</span>'; else echo 'png, gif';
				echo ' | ';
				if ($msg[2] == 'size') echo '<span class="error">max. 20 Ko</span>'; else echo 'max. 20 Ko';
			} else echo 'png, gif | max. 20 Ko'
			?>)</p>
		<p>
			<input type="file" name="img-upload" />
			<input type="hidden" name="MAX_FILE_SIZE" value="20480" />
			<input type="submit" name="submit-img" class="button" value="<?php _e('Upload'); ?>" />
		</p>
		<?php $helpclass = (isset($msg[2]) && $msg[2] == 'dim') ? ' class="error"' : ''; ?>
		<div<?php echo $helpclass; ?>>
			<p class="help"><?php printf(__('Don\'t forget, your image MUST be 22 emoticons wide and 1 emoticon tall.<br/>For example, if 1 emoticon is 16x16px, your image will be 352x16px.<br>Your custom emoticons will be located in <code>%s</code> and won\'t be erased on next update.', 'sf-smilies'), SF_SMILIES_CONTENT_IMGS_URL); ?></p>
		</div>
	</form>
	<div id="msg">
	<?php if (isset($msg)) {
		echo '<div class="'.$msg[1].'"><p>'.$msg[0];
		if ($msg[1] == 'updated') {
			echo '</br></br><img alt="'.$img['name'].'" src="'.SF_SMILIES_CONTENT_IMGS_URL.'/'.$img['name'].'"/>';
			return media_send_to_editor('');
		}
		echo '</p></div>';
	} ?>
	</div>
</body>
</html>
<?php
}
add_action('media_upload_sf_smilies_upload', 'sf_smilies_iframe');


/* Thickbox script for media upload window */
function sf_smilies_admin_scripts() {
	wp_enqueue_script('sf-smilies-admin', SF_SMILIES_PLUGIN_URL.'/js/admin.js', array('jquery'), '1.0', true);
	$protocol = isset( $_SERVER['HTTPS'] ) ? 'https://' : 'http://';
	$params = array( '_wpnonce' => wp_create_nonce ('sf-smilies-del-file_general'), 'smilies_url' => admin_url('options-general.php?page=sf_smilies_config', $protocol), 'ajax_url' => admin_url('admin-ajax.php', $protocol), 'change_current' => __('Please change your current smilies image before.', 'sf-smilies'), 'sure_delete' => __('Are you sure you want to delete this image?', 'sf-smilies') );
	wp_localize_script( 'sf-smilies-admin', 'sf_smilies_admin', $params );
	wp_enqueue_script('thickbox');
}


/* Thickbox css for media upload window */
function sf_smilies_admin_styles() {
	wp_enqueue_style('thickbox');
}

?>