<?php
/*
Plugin Name: SF Smilies
Plugin URI: http://scri.in/smilies
Description: Replace WordPress smilies <code>&lt;img&gt;</code> tags with <code>&lt;span&gt;</code> tags and use only one sprite image as background. Usefull for reducing http requests number and a better display in RSS readers. Also adds a toolbar to easily add smilies to posts, pages, custom posts, and comments. You can also change your icons.
Version: 0.5
Author: Grégory Viguier
Author URI: http://www.screenfeed.fr/
License: GPLv2
*/

DEFINE( 'SF_SMILIES_PLUGIN_URL', trailingslashit( WP_PLUGIN_URL ) . basename( dirname( __FILE__ ) ) );
DEFINE( 'SF_SMILIES_PLUGIN_DIR', trailingslashit( WP_PLUGIN_DIR ) . basename( dirname( __FILE__ ) ) );
DEFINE( 'SF_SMILIES_PLUGIN_IMGS_URL' , SF_SMILIES_PLUGIN_URL.'/images' );
DEFINE( 'SF_SMILIES_PLUGIN_IMGS_DIR' , SF_SMILIES_PLUGIN_DIR.'/images' );
$upload_dir = wp_upload_dir();
DEFINE( 'SF_SMILIES_CONTENT_IMGS_URL', $upload_dir['baseurl'].'/sf-smilies' );
DEFINE( 'SF_SMILIES_CONTENT_IMGS_DIR', $upload_dir['basedir'].'/sf-smilies' );
DEFINE( 'SF_SMILIES_PLUGIN_NAME', 'SF Smilies' );
DEFINE( 'SF_SMILIES_DB_VERSION', '0.1' );


/* In plugins list, "Settings link */
function sf_smilies_settings_action_links( $links, $file ) {
	if ( strstr( __FILE__, $file ) != '' ) {
		$settings_link = '<a href="' . admin_url( 'options-general.php?page=sf_smilies_config' ) . '">' . __( 'Settings' ) . '</a>';
		array_unshift( $links, $settings_link );
	}
	return $links;
}

/* Parts of the init */
if (is_admin()) {
	add_action( 'admin_init','sf_smilies_lang_init' );								// Localize
	require('sf-smilies-admin.inc.php');											// Admin
	require('sf-smilies-class.inc.php');											// Class
	add_action( 'admin_init', 'sf_smilies_register_settings' );						// Settings for admin
	add_action( 'admin_menu', 'sf_smilies_menu' );									// Menu item
	register_activation_hook( __FILE__, 'sf_smilies_default_values' );				// Activation
	register_uninstall_hook( __FILE__, 'sf_smilies_uninstaller' );					// Uninstall
	add_filter( 'plugin_action_links', 'sf_smilies_settings_action_links', 10, 2 );	// "Settings" link in plugins list
	add_action('wp_ajax_del_smilies', 'sf_smilies_delete_img');						// Delete emoticons with ajax
	if (isset($_GET['page']) && $_GET['page'] == 'sf_smilies_config') {
		add_action('admin_print_styles', array($sf_smilies, 'print_style'));		// CSS
		add_action('admin_init', array($sf_smilies, 'print_script'));				// JS
		add_action('admin_init', 'sf_smilies_admin_scripts');						// JS for thickbox
		add_action('admin_init', 'sf_smilies_admin_styles');						// CSS for thickbox
		add_action('contextual_help', 'sf_smilies_contextual_help',10,3);			// Trinity! Help me!
	} elseif ( $sf_smilies->options['use_smilies'] ) {
		add_action('admin_menu', 'sf_smilies_meta_box');							// Metabox for posts/pages/custom posts edit
		add_action('admin_print_styles', array($sf_smilies, 'print_style'));		// CSS
		add_action('admin_init', array($sf_smilies, 'print_script'));				// JS
	}
}
elseif ( get_option('use_smilies') ) {
	require('sf-smilies-class.inc.php');
	if (isset($sf_smilies->options['use_css']))
		add_action('wp_print_styles', array($sf_smilies, 'print_style'));
	if (isset($sf_smilies->options['use_bar']))
		add_action('comment_form', array($sf_smilies, 'print_toolbar'));
	if (isset($sf_smilies->options['use_js']))
		add_action('init', array($sf_smilies, 'print_script'));
}

?>