<?php

class sf_smilies {

	/*
	 * @var array Smilies to search in posts and their css class
	 */
	var $smiliestrans = array(
		':mrgreen:' => 'icon_mrgreen',
		':neutral:' => 'icon_neutral',
		':twisted:' => 'icon_twisted',
		  ':arrow:' => 'icon_arrow',
		  ':shock:' => 'icon_eek',
		  ':smile:' => 'icon_smile',
		    ':???:' => 'icon_confused',
		   ':cool:' => 'icon_cool',
		   ':evil:' => 'icon_evil',
		   ':grin:' => 'icon_biggrin',
		   ':idea:' => 'icon_idea',
		   ':oops:' => 'icon_redface',
		   ':razz:' => 'icon_razz',
		   ':roll:' => 'icon_rolleyes',
		   ':wink:' => 'icon_wink',
		    ':cry:' => 'icon_cry',
		    ':eek:' => 'icon_surprised',
		    ':lol:' => 'icon_lol',
		    ':mad:' => 'icon_mad',
		    ':sad:' => 'icon_sad',
		      '8-)' => 'icon_cool',
		      '8-O' => 'icon_eek',
		      ':-(' => 'icon_sad',
		      ':-)' => 'icon_smile',
		      ':-?' => 'icon_confused',
		      ':-D' => 'icon_biggrin',
		      ':-P' => 'icon_razz',
		      ':-o' => 'icon_surprised',
		      ':-x' => 'icon_mad',
		      ':-|' => 'icon_neutral',
		      ';-)' => 'icon_wink',
		       '8)' => 'icon_cool',
		       '8O' => 'icon_eek',
		       ':(' => 'icon_sad',
		       ':)' => 'icon_smile',
		       ':?' => 'icon_confused',
		       ':D' => 'icon_biggrin',
		       ':P' => 'icon_razz',
		       ':o' => 'icon_surprised',
		       ':x' => 'icon_mad',
		       ':|' => 'icon_neutral',
		       ';)' => 'icon_wink',
		      ':!:' => 'icon_exclaim',
		      ':?:' => 'icon_question'
		);

	public function __construct() {
		$this->options = get_option( 'sf_smilies_options' );
		$this->options['use_smilies'] = get_option('use_smilies');
		// If something's going wrong with the image field
		if (!isset($this->options['image']))
			$this->options['image'] = '16/0/0';
		$this->options['imgattr'] = explode('/', $this->options['image']);
		// We check if folders or images are missing...
		$this->check_dirs_and_files();
		// ...and we alert the user.
		add_action( 'admin_notices', array($this, 'show_errors') );
		
		remove_filter( 'the_content', 'convert_smilies' );
		remove_filter( 'the_excerpt', 'convert_smilies' );
		remove_filter( 'comment_text', 'convert_smilies', 20 );
		
		if ($this->options['use_smilies']) {
			add_filter('comment_text', array(&$this, 'convert_smilies'));
			add_filter('the_content', array(&$this, 'convert_smilies'));
			add_filter('the_excerpt', array(&$this, 'convert_smilies'));
		}
	}

	function translate_smiley($smiley) {
		if (count($smiley) == 0) return '';
		$smiley = trim(reset($smiley));
		$img = $this->smiliestrans[$smiley];
		$smiley_masked = esc_attr($smiley);
		return ' <span title="'.$smiley_masked.'" class="wp-smiley '.$img.'">'.$smiley_masked.'</span>';
	}

	function convert_smilies($text) {
		global $wp_smiliessearch;
		$output = '';
		if ( $this->options['use_smilies'] && !empty($wp_smiliessearch) ) {
			// HTML loop taken from texturize function, could possible be consolidated
			$textarr = preg_split("/(<.*>)/U", $text, -1, PREG_SPLIT_DELIM_CAPTURE); // capture the tags as well as in between
			$stop = count($textarr);// loop stuff
			for ($i = 0; $i < $stop; $i++) {
				$content = $textarr[$i];
				if ((strlen($content) > 0) && ('<' != $content[0])) { // If it's not a tag
					$content = preg_replace_callback($wp_smiliessearch, array(&$this, 'translate_smiley'), $content);
				}
				$output .= $content;
			}
		} else {
			// return default text.
			$output = $text;
		}
		return $output;
	}

	function print_style() {
		$d = $this->options['imgattr'][0];
		$smilies_folder = ($this->options['imgattr'][2] == 'personal') ? SF_SMILIES_CONTENT_IMGS_URL : SF_SMILIES_PLUGIN_IMGS_URL;
		$style = '<style type="text/css">';
		if (is_admin()) {
			$lh = $d + 17;
			$style .='#smilies-bar{line-height:'.$lh.'px}'
					.'#smilies-images label{display:inline-block;margin:4px 0;padding-right:20px;position:relative}'
					.'#smilies-images .delete-file{display:block;width:14px;height:14px;margin-top:-4px;position:absolute;right:0;top:50%;cursor:pointer;background:transparent url('.SF_SMILIES_PLUGIN_URL.'/delete.png) 0 0 no-repeat}'
					.'#smilies-images label:not(:hover) .delete-file{display:none}'
					.'#sf_smilies_box #smilies-bar{padding:0}'
					.'#smilies-bar label{margin-right:3px;line-height:'.$d.'px;display:inline-block}'
					.'#sf-smilies .metabox-holder .inside{margin:0 6px 8px}';
		} else {
			$style .='#smilies-bar{line-height:'.$d.'px}';
		}
		$style .='#smilies-bar .wp-smiley{cursor:pointer;margin:0 2px 2px 0}'
				.'.wp-smiley{display:inline-block;width:'.$d.'px;height:'.$d.'px;text-indent:-9999px;background:transparent url('.$smilies_folder.'/'.$this->options['imgattr'][1].') 0 0 no-repeat}';
		$icons = array('icon_arrow', 'icon_biggrin', 'icon_confused', 'icon_cool', 'icon_cry', 'icon_eek',
					   'icon_evil', 'icon_exclaim', 'icon_idea', 'icon_lol', 'icon_mad', 'icon_mrgreen',
					   'icon_neutral', 'icon_question', 'icon_razz', 'icon_redface', 'icon_rolleyes', 'icon_sad',
					   'icon_smile', 'icon_surprised', 'icon_twisted', 'icon_wink');
		foreach ($icons as $i => $icon) {
			$x = $d*$i;
			$style .= '.'.$icon.'{background-position:-'.$x.'px 0}';
		}
		$style .='</style>';
		echo $style;
	}

	function print_toolbar() {
		echo '<div id="smilies-bar">'."\n";
		foreach ( $this->options['icons'] as $props ) {
			if (isset($props['disp']))
				echo '<span title="'.$props['symb'].'" class="wp-smiley '.$props['name'].'">'.$props['symb'].'</span> ';
		}
		echo "\n".'</div>'."\n";
	}

	function print_script() {
		wp_register_script('insert-icons', SF_SMILIES_PLUGIN_URL.'/js/insert-icons.js', array('jquery'), '1.0', true);
		wp_enqueue_script('insert-icons');
	}

	function fetch_smilies_in_dir($handle) {
		$images = glob($handle.'/*.{gif,png}', GLOB_BRACE);
		foreach ($images as $i => $file) {
			$images[$i] = basename($images[$i]);
		}
		return $images;
	}

	function check_dirs_and_files() {
		$cur_smilies_dir = ($this->options['imgattr'][2] == 'personal') ? SF_SMILIES_CONTENT_IMGS_DIR : SF_SMILIES_PLUGIN_IMGS_DIR;
		$cur_error = get_option('sf-smilies-error');
		if (!isset($cur_error['type']))
			$cur_error['type'] = '';		// If we have no error, 'type' is not 'undefined' anymore
		if ( !file_exists($cur_smilies_dir.'/'.$this->options['imgattr'][1]) && isset($this->options['use_smilies']) && ( isset($this->options['use_css']) || $cur_error['type'] == 'error' ) ) {
			if ($cur_error['type'] == 'error' && !is_admin())
				return;
			$feat_img = array();
			$dir_exists = 0;
			if (is_dir(SF_SMILIES_PLUGIN_IMGS_DIR)) {							// If plugin images folder exists
				$plug_imgs = $this->fetch_smilies_in_dir(SF_SMILIES_PLUGIN_IMGS_DIR);
				$dir_exists = 1;
				if (count($plug_imgs)) {										// If plugin images folder has images
					$feat_img = array(SF_SMILIES_PLUGIN_IMGS_DIR, $plug_imgs[0], '/plugin');
				}
			}
			if (is_dir(SF_SMILIES_CONTENT_IMGS_DIR) && !count($feat_img)) {		// If personal images folder exists and $feat_img is still empty
				$pers_imgs = $this->fetch_smilies_in_dir(SF_SMILIES_CONTENT_IMGS_DIR);
				$dir_exists = 1;
				if (count($pers_imgs)) {										// If personal images folder has images
					$feat_img = array(SF_SMILIES_CONTENT_IMGS_DIR, $pers_imgs[0], '/personal');
				}
			}
			if (!$dir_exists) {													// Directories are missing
				$error = array(
					'message' => sprintf(__('<b>Error:</b> It seems that you deleted all your smilies folders for %s. Plugin CSS has been deactivated. Please check your folders before re-enabling it.', 'sf-smilies'), SF_SMILIES_PLUGIN_NAME),
					'type' => 'error'
					);
				update_option( 'sf-smilies-error', $error );
			}
			elseif (count($feat_img)) {											// Active image file is missing
				$error = array(
					'message' => sprintf(__('<b>Notice:</b> Apparently, you have deleted your current smilies package. %1$s chose an other one for you. Please go to %1$s settings to remove this alert and validate changes.', 'sf-smilies'), SF_SMILIES_PLUGIN_NAME),
					'type' => 'updated'
					);
				update_option( 'sf-smilies-error', $error );
				// Now we change the active image file, re-activate CSS, and update settings
				$feat_img_attr = getimagesize($feat_img[0].'/'.$feat_img[1]);
				$this->options['image'] = $feat_img_attr[1].'/'.$feat_img[1].$feat_img[2];
				$this->options['use_css'] = 1;
				update_option('sf_smilies_options', $this->options);
				$this->options['imgattr'] = explode('/', $this->options['image']);
			}
			else {																// Files are missing
				$error = array(
					'message' => sprintf(__('<b>Error:</b> It seems that you deleted all your smilies files for %s. Plugin CSS has been deactivated. Please check your files before re-enabling it.', 'sf-smilies'), SF_SMILIES_PLUGIN_NAME),
					'type' => 'error'
					);
				update_option( 'sf-smilies-error', $error );
			}
		} elseif (file_exists($cur_smilies_dir.'/'.$this->options['imgattr'][1]) && $cur_error['type'] == 'error') {		// Current file is now OK but I still have a previous 'error'
			delete_option( 'sf-smilies-error' );
			$this->options['use_css'] = 1;
			update_option('sf_smilies_options', $this->options);
		}
	}

	function show_errors() {
		if ($error = get_option( 'sf-smilies-error' )) {
			echo '<div class="'.$error['type'].'"><p>'.$error['message'].'</p></div>';
			if ($error['type'] == 'error') {
				$this->options = get_option( 'sf_smilies_options' );
				unset($this->options['use_css']);
				update_option('sf_smilies_options', $this->options);
			}
		}
	}

}

$sf_smilies = new sf_smilies;


/* For easyly inserting the bar in theme */
function sf_smilies_bar() {
	global $sf_smilies;
	$sf_smilies->print_toolbar();
}


?>