<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

/*------------------------------------------------------------------------------------------------*/
/* !GET NUMBER OF SHARES PER SOCIAL MEDIA ======================================================= */
/*------------------------------------------------------------------------------------------------*/

class SF_Share_Count {
	protected $url;
	protected $args;

	public function __construct( $url,$timeout = 10 ) {
		$this->url  = rawurldecode( esc_url( $url ) );
		$this->args = array(
			'timeout'    => absint( $timeout ),
			'decompress' => false,
		);
	}


	// Generic request

	public function request( $url, $args = array() ) {
		$args = array_merge( $this->args, $args );
		$resp = wp_remote_get( $url, $args );

		if ( is_wp_error( $resp ) ) {
			return 'error-0';
		}

		$code = absint( wp_remote_retrieve_response_code( $resp ) );

		if ( $code < 200 || $code > 205 ) {
			return 'error-' . $code;
		}

		return wp_remote_retrieve_body( $resp );
	}


	// Twitter

	public function get_twitter_shares() {
		$url  = apply_filters( 'sfss_counter_api_url', 'http://urls.api.twitter.com/1/urls/count.json?url=%s', 'twitter' );
		$resp = $this->request( sprintf( $url, $this->url ) );

		if ( 0 === strpos( $resp, 'error-' ) ) {
			return $resp;
		}

		$resp = json_decode( $resp );

		if ( ! is_object( $resp ) ) {
			return 'error-';
		}

		return isset( $resp->count ) ? absint( $resp->count ) : 'error-';
	}


	// Facebook

	public function get_facebook_shares() {
		$url  = apply_filters( 'sfss_counter_api_url', 'http://graph.facebook.com/%s', 'facebook' );
		$resp = $this->request( sprintf( $url, $this->url ) );

		if ( 0 === strpos( $resp, 'error-' ) ) {
			return $resp;
		}

		$resp = json_decode( $resp );

		if ( ! is_object( $resp ) || empty( $resp->id ) ) {
			return 'error-';
		}

		return isset( $resp->shares ) ? absint( $resp->shares ) : 0;
	}


	// Google

	public function get_google_shares() {
		$args = array(
			'method'  => 'POST',
			'headers' => array( 'Content-type' => 'application/json' ),
			'body'    => json_encode( array( (object) array(
				'method' => 'pos.plusones.get',
				'id'     => 'p',
				'params' => (object) array(
					'nolog'   => true,
					'id'      => $this->url,
					'source'  => 'widget',
					'userId'  => '@viewer',
					'groupId' => '@self',
				),
				'jsonrpc'    => '2.0',
				'key'        => 'p',
				'apiVersion' => 'v1',
			) ) ),
		);

		$url  = apply_filters( 'sfss_counter_api_url', 'https://clients6.google.com/rpc', 'google' );
		$resp = $this->request( sprintf( $url, $this->url ), $args );

		if ( 0 === strpos( $resp, 'error-' ) ) {
			return $resp;
		}

		$resp = json_decode( $resp );

		if ( ! is_array( $resp ) ) {
			return 'error-';
		}

		$resp = reset( $resp );

		return is_object( $resp ) && isset( $resp->result->metadata->globalCounts->count ) ? absint( $resp->result->metadata->globalCounts->count ) : 'error-';
	}


	// Pinterest

	public function get_pinterest_shares() {
		$url  = apply_filters( 'sfss_counter_api_url', 'https://api.pinterest.com/v1/urls/count.json?url=%s', 'pinterest' );
		$resp = $this->request( sprintf( $url, $this->url ) );

		if ( 0 === strpos( $resp, 'error-' ) ) {
			return $resp;
		}

		$resp = preg_replace( '@^receiveCount\((.*)\)$@', '\\1', $resp );
		$resp = json_decode( $resp );

		return is_object( $resp ) && isset( $resp->count ) ? absint( $resp->count ) : 'error-';
	}


	// LinkedIn

	public function get_linkedin_shares() {
		$url  = apply_filters( 'sfss_counter_api_url', 'https://www.linkedin.com/countserv/count/share?format=json&url=%s', 'linkedin' );
		$resp = $this->request( sprintf( $url, $this->url ) );

		if ( 0 === strpos( $resp, 'error-' ) ) {
			return $resp;
		}

		$resp = json_decode( $resp );

		return is_object( $resp ) && isset( $resp->count ) ? absint( $resp->count ) : 'error-';
	}
}


/**/