(function( w, d, $, undefined ) {

	var shareWindowRef = {};

	// !Get window width and height.
	function viewport() {
		var e = w,
			a = "inner";

		if ( ! ( "innerWidth" in w ) ) {
			a = "client";
			e = document.documentElement || document.body;
		}

		return { width : e[ a + "Width" ], height : e[ a + "Height" ] };
	}
	// !Get screen position.
	function screenPos() {
		var pos = { left: 0, top: 0 };
		if ( w.mozInnerScreenX ) {
			pos.left = w.mozInnerScreenX;
		}
		else if ( w.screenLeft ) {
			pos.left = w.screenLeft;
		}
		else if ( w.screenX ) {
			pos.left = w.screenX;
		}

		if ( w.mozInnerScreenY ) {
			pos.top = w.mozInnerScreenY;
		}
		else if ( w.screenTop ) {
			pos.top = w.screenTop;
		}
		else if ( w.screenY ) {
			pos.top = w.screenY;
		}

		return pos;
	}

	// !Update counters via ajax.
	function sfssUpdate() {
		var $this  = $( this ),
			postId = $this.data( "postid" );

		if ( postId === undefined || ! postId ) {
			return true;
		}

		postId = Number( postId );
		$this.addClass( "loading" );

		$.getJSON( w.sfssL10n.ajaxurl, { "action": "get-share-counts", "post_id" : postId }, function( resp ) {
			if ( resp.success && resp.data ) {
				$.each( resp.data, function( network, ndata ) {
					var el = $this.find( ".share-" + network + " .count" ).text( Number( ndata.count ) );

					if ( ndata.error !== "" ) {
						el.parents( ".sfss-share-button" ).attr( "data-error", Number( ndata.error ) );
					}
					else {
						el.parents( ".sfss-share-button" ).removeAttr( "data-error" );
					}
				} );
			}

			$this.removeClass( "loading" );
		} );

		$this.removeClass( "sfss-needs-update" );
	}

	// !Share the post.
	function sfssShare( e ) {
		var $this  = $( this ),
			width  = $this.data( "w" ),
			height = $this.data( "h" ),
			id     = $this.data( "id" ),
			url    = $this.attr( "href" ),
			view, pos, popLeft, popTop;

		if ( ! width || height === undefined || ! height || id === undefined || ! id || ! id.match( /^[a-z]+-\d+$/ ) ) {
			return true;
		}

		e.preventDefault();

		if ( ! shareWindowRef[ id ] || shareWindowRef[ id ].closed ) {
			width   = Number( width );
			height  = Number( height );
			view    = viewport();
			pos     = screenPos();
			popLeft = Math.ceil( ( view.width - width ) / 2 ) + pos.left;
			popTop  = Math.ceil( ( view.height - height ) / 2 ) + pos.top;
			shareWindowRef[ id ] = w.open( url, id, "width=" + width + ",height=" + height + ",left=" + popLeft + ",top=" + popTop );
		}
		else {
			shareWindowRef[ id ].focus();
		}
	}

	// !Bind events.
	$( ".sfss-needs-update" ).each( sfssUpdate );

	$( d.body ).on( "click", ".sfss-share-button[data-w]", sfssShare );

} )(window, document, jQuery);