<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}

add_action( 'wp_ajax_get-share-counts', 'sfss_ajax_shares' );
add_action( 'wp_ajax_nopriv_get-share-counts', 'sfss_ajax_shares' );

function sfss_ajax_shares() {
	if ( empty( $_REQUEST['post_id'] ) ) {
		wp_send_json_error();
	}

	$post_id  = absint( $_REQUEST['post_id'] );
	$networks = sfss_get_networks( $post_id );

	if ( ! $networks ) {
		wp_send_json_error();
	}

	$permalink = get_permalink( $post_id );

	if ( ! $permalink ) {
		wp_send_json_error();
	}

	// Will tell if we need to fetch fresh infos.
	$needs_update = false;
	// Output
	$shares       = array();

	// Check if we need to update the counters (and get stored values otherwise).
	foreach ( $networks as $network => $atts ) {
		$count = get_post_meta( $post_id, '_' . $network, true );

		if ( '' === $count ) {
			// The post meta does not exist yet, we need to gather our first infos.
			$needs_update = true;
			break;
		}

		$error = get_post_meta( $post_id, '_' . $network . '-error', true );
		$error = '' === $error ? '' : absint( $error );

		$shares[ $network ] = array( 'error' => $error, 'count' => sfss_counter_format( $count ) );
	}

	if ( ! $needs_update ) {
		$post_age = floor( time() - get_post_time( 'U', false, $post_id ) );

		// 0 to 14 days: check every hour.
		if ( $post_age <= ( 14 * DAY_IN_SECONDS ) ) {
			$interval = HOUR_IN_SECONDS;
		}
		// 15 to 60 days: check every 4 hours.
		elseif ( $post_age <= ( 60 * DAY_IN_SECONDS ) ) {
			$interval = 4 * HOUR_IN_SECONDS;
		}
		// More than 60 days: check every 12 hours.
		else {
			$interval = 12 * HOUR_IN_SECONDS;
		}

		$last = absint( get_post_meta( $post_id, '_sftt_last_check', true ) ); // timestamp

		$needs_update = ! $last || ( time() > ( $last + $interval ) );
	}

	// Get new values.
	if ( $needs_update ) {

		$class    = apply_filters( 'sfss_share_count_class', 'SF_Share_Count', $post_id );
		$instance = new $class( $permalink );

		foreach ( $networks as $network => $atts ) {
			if ( ! empty( $atts['callback'] ) && is_callable( $atts['callback'] ) ) {
				$count = call_user_func( $atts['callback'], $network );
			}
			elseif ( method_exists( $instance, 'get_' . $network . '_shares' ) ) {
				$count = call_user_func( array( $instance, 'get_' . $network . '_shares' ) );
			}
			else {
				break;
			}

			if ( is_string( $count ) ) {
				// Error code.
				$error = absint( substr( $count, 6 ) );
				update_post_meta( $post_id, '_' . $network . '-error', $error );

				// Use the previous value for the counter.
				$count = absint( get_post_meta( $post_id, '_' . $network, true ) );
				update_post_meta( $post_id, '_' . $network, $count );
				$shares[ $network ] = array( 'error' => $error, 'count' => sfss_counter_format( $count ) );
			}
			elseif ( update_post_meta( $post_id, '_' . $network, $count ) ) {
				delete_post_meta( $post_id, '_' . $network . '-error' );
				$shares[ $network ] = array( 'error' => '', 'count' => sfss_counter_format( $count ) );
			}
			else {
				delete_post_meta( $post_id, '_' . $network . '-error' );
				unset( $shares[ $network ] );
			}
		}

		update_post_meta( $post_id, '_sftt_last_check', time() ); // timestamp
	}

	wp_send_json_success( $shares );
}

/**/