<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}


/*-----------------------------------------------------------------------------------*/
/* !I18N =========================================================================== */
/*-----------------------------------------------------------------------------------*/

add_action( 'init', 'sfss_i18n' );

function sfss_i18n() {
	load_plugin_textdomain( 'sf-social-share', false, basename( dirname( SFSS_FILE ) ) . '/languages/' );
}


/*-----------------------------------------------------------------------------------*/
/* !STYLES ========================================================================= */
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_enqueue_scripts', 'sfss_styles', 20 );

function sfss_styles() {

	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	$ver = $min ? SFSS_VERSION : time();

	wp_enqueue_style( 'sfss-style', plugin_dir_url( SFSS_FILE ) . 'res/css/sfss-front' . $min . '.css', false, $ver, 'all' );
}


/*-----------------------------------------------------------------------------------*/
/* !SCRIPTS ======================================================================== */
/*-----------------------------------------------------------------------------------*/

add_filter( 'sfss_buttons', 'sfss_scripts' );

function sfss_scripts( $out ) {

	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	$ver = $min ? SFSS_VERSION : time();

	wp_enqueue_script( 'sfss-script', plugin_dir_url( SFSS_FILE ) . 'res/js/sfss-front' . $min . '.js', array( 'jquery' ), $ver, true );
	wp_localize_script( 'sfss-script', 'sfssL10n', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

	return $out;
}


/*-----------------------------------------------------------------------------------*/
/* !BODY CLASS ===================================================================== */
/*-----------------------------------------------------------------------------------*/

// !Add a class to the body, it is used to display the errors on the buttons.

add_filter( 'body_class', 'sfss_body_class' );

function sfss_body_class( $classes ) {
	if ( is_singular() && is_user_logged_in() ) {
		$post      = get_queried_object();
		$post_type = get_post_type_object( $post->post_type );

		if ( current_user_can( SFSS_CAPABILITY ) || current_user_can( $post_type->edit_post, $post->ID ) ) {
			$classes[] = 'sfss-display-errors';
		}
	}

	return $classes;
}


/*-----------------------------------------------------------------------------------*/
/* !TEMPLATE TAGS ================================================================== */
/*-----------------------------------------------------------------------------------*/

function sfss_share_buttons( $post_id = null, $args = array() ) {
	echo sfss_get_share_buttons( $post_id, $args );
}


function sfss_get_share_buttons( $post_id = null, $args = array() ) {
	static $instance = 0;
	static $decode_flag;

	if ( ! apply_filters( 'sfss_display_buttons', true, $post_id ) ) {
		return;
	}

	$post_id = $post_id ? $post_id : get_the_id();

	if ( ! $post_id ) {
		return array();
	}

	$networks = sfss_get_networks( $post_id );

	if ( ! $networks ) {
		return array();
	}

	// Will tell if we need to fetch fresh infos.
	$needs_update = apply_filters( 'sfss_use_html_cache', false, $post_id );

	// Get current counters.
	$buttons = $networks;

	foreach ( $buttons as $network => $atts ) {
		$buttons[ $network ] = get_post_meta( $post_id, '_' . $network, true );

		if ( ! $needs_update && '' === $buttons[ $network ] ) {
			// The post meta does not exist yet, we need to gather our first infos.
			$needs_update = true;
		}

		$buttons[ $network ] = sfss_counter_format( $buttons[ $network ] );
	}

	// Check if we need to update the counters.
	if ( ! $needs_update ) {
		$post_age = floor( time() - get_post_time( 'U', false, $post_id ) );

		// 0 to 14 days: check every hour.
		if ( $post_age <= ( 14 * DAY_IN_SECONDS ) ) {
			$interval = HOUR_IN_SECONDS;
		}
		// 15 to 60 days: check every 4 hours.
		elseif ( $post_age <= ( 60 * DAY_IN_SECONDS ) ) {
			$interval = 4 * HOUR_IN_SECONDS;
		}
		// More than 60 days: check every 12 hours.
		else {
			$interval = 12 * HOUR_IN_SECONDS;
		}

		$last = absint( get_post_meta( $post_id, '_sftt_last_check', true ) ); // timestamp

		$needs_update = ! $last || ( time() > ( $last + $interval ) );
	}

	// Start dealing with the HTML.

	/* Translators: 1: social network label, 2: total shares */
	$button_text  = _x( '%1$s: %2$s shares', 'button text', 'sf-social-share' );
	/* Translators: 1: social network label (please use %1$s, not %s) */
	$button_title = esc_attr_x( 'Share on %1$s', 'button title attribute', 'sf-social-share' );

	$args = array_merge( array(
		'wrapper_tag' => 'footer',
		'hide_label'  => false,
		'share_email' => true,
		'twitter_id'  => false,
		// 1: network label, 2: total shares, 3: network slug, 4: URL, 5: mini window width, 6: mini window height, 7: mini window identifier ({network slug}-{post_id}), 8: data-error attribute.
		'button_tmpl' => '<a rel="nofollow" class="sfss-share-button share-%3$s" target="_blank" title="' . $button_title . '" href="%4$s" data-w="%5$s" data-h="%6$s" data-id="%7$s"%8$s><span class="icon icon-%3$s" aria-hidden="true"></span><span class="screen-reader-text">' . $button_text . '</span></a>',
	), $args );
	$args = apply_filters( 'sfss_buttons_args', $args, $post_id );

	if ( ! isset( $decode_flag ) ) {
		$decode_flag = version_compare( PHP_VERSION, '5.4' ) >= 0 ? ENT_HTML5 : ENT_COMPAT | ENT_HTML401;
	}

	$instance++;
	$hrefs = array(
		// 1: post title, 2: permalink, 3: Twitter via, 4: Twitter title, 5: thumbnail URL
		'twitter'   => 'https://twitter.com/intent/tweet?source=webclient&amp;original_referer=%2$s&amp;text=%4$s&amp;url=%2$s%3$s',
		'facebook'  => 'https://www.facebook.com/sharer/sharer.php?u=%2$s',
		'google'    => 'https://plus.google.com/share?url=%2$s',
		'pinterest' => 'https://pinterest.com/pin/create/button/?url=%2$s&amp;description=%1$s%5$s',
		'linkedin'  => 'https://www.linkedin.com/cws/share?url=%2$s',
	);

	/*
	 * $title_cutoff: number of caracters used to calculate the length the title must have to fit in a tweet.
	 * 140: a tweet length.
	 * 22: tipically permalink length once shorten by Twitter.
	 * 1: space caracters.
	 */
	$title_cutoff = 140 - 1 - 22 - 1;
	$twitter_via  = '';
	$hellip       = html_entity_decode( '&hellip;', $decode_flag, 'UTF-8' );

	if ( $args['twitter_id'] ) {
		$twitter_via   = '&amp;via=' . esc_attr( ltrim( $args['twitter_id'], '@' ) );
		$title_cutoff -= strlen( utf8_decode( $args['twitter_id'] ) ) - 6; // strlen( ' via @' ) = 6
	}

	$post_title    = wp_strip_all_tags( get_the_title( $post_id ) );
	$post_title    = html_entity_decode( $post_title, $decode_flag, 'UTF-8' );

	$twitter_title = apply_filters( 'sfss_tweet_filter', $post_title, $post_id );
	$twitter_title = sfss_trim_caracters( $twitter_title, $title_cutoff, $hellip );
	$twitter_title = str_replace( '+', '%20', urlencode( $twitter_title ) );

	$post_title    = str_replace( '+', '%20', urlencode( $post_title ) );

	$permalink     = urlencode( esc_url( get_permalink( $post_id ) ) );
	$thumbnail     = has_post_thumbnail( $post_id ) ? '&amp;media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id( $post_id ) ) ) : '';

	$out  = "\t\t\t\t\t\t".'<' . $args['wrapper_tag'] . ' class="sfss-share-buttons share-buttons entry-meta' . ( $needs_update ? ' sfss-needs-update' : '' ) . '" aria-labelledby="share-buttons-title-' . $instance . '" data-postID="' . $post_id . '">';

		$out .= '<span id="share-buttons-title-' . $instance . '"' . ( $args['hide_label'] ? ' class="screen-reader-text"' : '' ) . '>' . __( 'Share:', 'sf-social-share' ) . '</span> ';

		foreach ( $buttons as $network => $counter ) {
			$counter = '</span><span class="count">' . $counter . '</span><span class="screen-reader-text">';
			$href    = sprintf( $hrefs[ $network ], $post_title, $permalink, $twitter_via, $twitter_title, $thumbnail );
			$width   = ! empty( $networks[ $network ]['width'] )  ? absint( $networks[ $network ]['width'] )  : 0;
			$height  = ! empty( $networks[ $network ]['height'] ) ? absint( $networks[ $network ]['height'] ) : 0;
			$error   = get_post_meta( $post_id, '_' . $network . '-error', true );
			$error   = '' !== $error ? ' data-error="' . absint( $error ) . '"' : '';
			$out    .= sprintf( $args['button_tmpl'], esc_html( $networks[ $network ]['label'] ), $counter, $network, $href, $width, $height, $network . '-' . $post_id, $error );
		}

		if ( $args['share_email'] ) {
			$out .= sprintf(
				'<a rel="nofollow" class="sfss-share-button share-mail" title="%1$s" href="mailto:?subject=%2$s&amp;body=%3$s"><span class="icon icon-mail" aria-hidden="true"></span><span class="screen-reader-text">%4$s</span></a>',
				esc_attr__( 'Share by Email', 'sf-social-share' ), $post_title, $permalink, __( 'Share by Email', 'sf-social-share' )
			);
		}

	$out .= '</' . $args['wrapper_tag'] . ">\n";

	return apply_filters( 'sfss_buttons', $out, $args, $post_id, $needs_update, $instance );
}


// !Like `wp_trim_words()` but trim caracters only.

function sfss_trim_caracters( $text, $num_words = 55, $more = '' ) {

	$text = trim( preg_replace( "/[\n\r\t ]+/", ' ', $text ), ' ' );
	preg_match_all( '/./u', $text, $words_array );
	$words_array = array_slice( $words_array[0], 0, $num_words + 1 );

	if ( count( $words_array ) > $num_words ) {
		array_pop( $words_array );
		$text = implode( '', $words_array );
		$text = rtrim( $text, '# ' ) . $more;
	}
	else {
		$text = implode( '', $words_array );
	}

	return $text;
}

/**/