<?php
/*
 * Plugin Name: SF Social Share
 * Plugin URI: http://www.screenfeed.fr/plugin-wp/sf-social-share/
 * Description: Share + buttons + awesomeness.
 * Version: 1.1.2
 * Author: Grégory Viguier
 * Author URI: http://www.screenfeed.fr/greg/
 * License: GPLv3
 * License URI: http://www.screenfeed.fr/gpl-v3.txt
 * Text Domain: sf-social-share
 * Domain Path: /languages/
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin\' uh?' );
}
if ( version_compare( $GLOBALS['wp_version'], '3.5' ) < 0 ) {
	return;
}

/*------------------------------------------------------------------------------------------------*/
/* !CONSTANTS =================================================================================== */
/*------------------------------------------------------------------------------------------------*/

define( 'SFSS_VERSION', '1.1.2' );
define( 'SFSS_FILE',    __FILE__ );

if ( ! defined( 'SFSS_CAPABILITY' ) ) {
	define( 'SFSS_CAPABILITY', 'edit_theme_options' );
}


/*------------------------------------------------------------------------------------------------*/
/* !INCLUDES ==================================================================================== */
/*------------------------------------------------------------------------------------------------*/

add_action( 'plugins_loaded', 'sfss_includes' );

function sfss_includes() {

	$plugin_dir = plugin_dir_path( SFSS_FILE );

	if ( doing_ajax() ) {

		include( $plugin_dir . 'inc/class-sf-share-count.php' );
		include( $plugin_dir . 'inc/ajax.php' );

	}
	elseif ( is_admin() ) {

		// Nothing yet.

	}
	elseif ( is_frontend() ) {

		include( $plugin_dir . 'inc/frontend.php' );

	}
}


/*------------------------------------------------------------------------------------------------*/
/* !UPDATES ===================================================================================== */
/*------------------------------------------------------------------------------------------------*/

if ( is_admin() ) {

	// Updater
	if ( ! function_exists( 'sf_updater_check_update' ) ) {
		include( plugin_dir_path( SFSS_FILE ) . 'inc/updater.inc.php' );
	}


	add_filter( 'sf_plugins_updates', 'sfss_update' );

	function sfss_update( $plugins = array() ) {
		$plugins[ SFSS_FILE ] = SFSS_VERSION;
		return $plugins;
	}

}


/*------------------------------------------------------------------------------------------------*/
/* !FILTERS ===================================================================================== */
/*------------------------------------------------------------------------------------------------*/

// !When a post is updated, we delete the "last check" timestamp. This will force our counters to be updated.

add_action( 'save_post', 'sfss_flush_post_meta_cache', 10, 3 );

function sfss_flush_post_meta_cache( $post_ID, $post, $update ) {
	if ( $update ) {
		delete_post_meta( $post_ID, '_sftt_last_check' );
	}
}


/*------------------------------------------------------------------------------------------------*/
/* !TOOLS ======================================================================================= */
/*------------------------------------------------------------------------------------------------*/

// !Get the networks we want to display.

function sfss_get_networks( $post_id = null ) {
	static $buttons = array();

	if ( ! isset( $buttons[ $post_id ] ) ) {
		$networks = array(
			'twitter'   => array( 'label' => 'Twitter',   'width' => 680, 'height' => 443, ),
			'facebook'  => array( 'label' => 'Facebook',  'width' => 410, 'height' => 303, ),
			'google'    => array( 'label' => 'Google+',   'width' => 672, 'height' => 742, ),
			'pinterest' => array( 'label' => 'Pinterest', 'width' => 750, 'height' => 600, ),
			'linkedin'  => array( 'label' => 'LinkedIn',  'width' => 600, 'height' => 216, ),
		);
		$buttons[ $post_id ] = apply_filters( 'sfss_networks', $networks, $post_id );
		$buttons[ $post_id ] = is_array( $buttons[ $post_id ] ) && $buttons[ $post_id ] ? array_filter( $buttons[ $post_id ] ) : array();
	}

	return $buttons[ $post_id ];
}


// !Kind of `size_format()`.

function sfss_counter_format( $counter, $decimals = 1 ) {
	$counter = absint( $counter );

	if ( $counter < 1000 ) {
		return $counter;
	}

	$quant = array(
		// ======================== Origin ====
		'T' => 1000000000000,  // pow( 1000, 4)
		'G' => 1000000000,     // pow( 1000, 3)
		'M' => 1000000,        // pow( 1000, 2)
		'k' => 1000,           // pow( 1000, 1)
	);

	foreach ( $quant as $unit => $mag ) {
		if ( doubleval( $counter ) >= $mag ) {
			return number_format_i18n( $counter / $mag, $decimals ) . ' ' . $unit;
		}
	}

	return false;
}


if ( ! function_exists( 'doing_ajax' ) ) :
function doing_ajax() {
	return defined( 'DOING_AJAX' ) && DOING_AJAX && is_admin();
}
endif;


if ( ! function_exists( 'is_frontend' ) ) :
function is_frontend() {
	return ! defined( 'XMLRPC_REQUEST' ) && ! defined( 'DOING_CRON' ) && ! is_admin();
}
endif;

/**/