<?php

/* Provided by ScreenfeedFr : http://scri.in/midjs */

/* Can enqueue scripts at mid-page for WP 3.3+ and < 3.3. Works exactly like wp_enqueue_script. Uses sf_handle_scripts_deps. */
if (!function_exists('sf_enqueue_script')) {
	function sf_enqueue_script($handle = '', $src = false, $deps = array(), $ver = false, $in_footer = false) {
		if ( $handle == '' )
			return;

		if ( function_exists('wp_trim_words') || !did_action('wp_print_scripts') ) {	// WP 3.3+

			wp_enqueue_script($handle, $src, $deps, $ver, $in_footer);

		} else {																		// WP < 3.3
			global $wp_scripts;
			if ( ! is_a( $wp_scripts, 'WP_Scripts' ) ) {
				if ( ! did_action( 'init' ) )
					_doing_it_wrong( __FUNCTION__, sprintf( __( 'Scripts and styles should not be registered or enqueued until the %1$s, %2$s, or %3$s hooks.' ),
						'<code>wp_enqueue_scripts</code>', '<code>admin_enqueue_scripts</code>', '<code>init</code>' ), '3.3' );
				$wp_scripts = new WP_Scripts();
			}
			if ( $src ) {
				$_handle = explode('?', $handle);
				$handle  = $_handle[0];
				$wp_scripts->add( $handle, $src, $deps, $ver );
			}
			$wp_scripts->enqueue( $handle );
			$wp_scripts->groups[$handle] = 1;
			// Now we really add the script in the list of scripts to print in footer
			$wp_scripts->in_footer[] = $handle;
			// Many things could happen, we'll deal with dependencies just before print the scripts
			add_action('wp_print_footer_scripts', 'sf_handle_scripts_deps');
		}
	}
}


/* Handle scripts dependencies just before print them (for WP < 3.3). Used in sf_enqueue_script */
if (!function_exists('sf_handle_scripts_deps')) {
	function sf_handle_scripts_deps() {
		global $wp_scripts;
		// Look if dependencies are registered.
		$wp_scripts->all_deps($wp_scripts->in_footer);
		$to_dos = array();
		foreach ($wp_scripts->to_do as $key => $to_do) {
			$to_dos[] = $to_do;
			if ( !in_array($to_do, $wp_scripts->in_footer) && !in_array($to_do, $wp_scripts->done) ) {
				$wp_scripts->enqueue( $to_do );
				$wp_scripts->add_data( $to_do[0], 'group', 1 );
				$wp_scripts->groups[$to_do] = 1;
			}
			unset($wp_scripts->to_do[$key]);
		}
		$wp_scripts->in_footer = $to_dos;
	}
}


/* Like wp_localize_script but for WP 3.3+ and < 3.3 */
if ( !function_exists( 'sf_localize_script' ) ) {
	function sf_localize_script( $handle, $object_name, $l10n ) {
		if ( ( is_array($l10n) && count($l10n) ) && !function_exists('wp_trim_words') ) {		// $l10n is an array and WP < 3.3
			if (isset($l10n['l10n_print_after']) && $l10n['l10n_print_after']) {
				$new_l10n = array( 'l10n_print_after' => $l10n['l10n_print_after'] );
				unset($l10n['l10n_print_after']);
				$new_l10n['l10n_print_after'] = 'var '.$object_name.' = '.json_encode($l10n).';'."\n".$new_l10n['l10n_print_after'];
			} else {
				$new_l10n = array();
				$new_l10n['l10n_print_after'] = 'var '.$object_name.' = '.json_encode($l10n).';';
			}
			wp_localize_script( $handle, $object_name.'0', $new_l10n );
		} else
			wp_localize_script( $handle, $object_name, $l10n );
	}
}

?>