<?php
add_action( 'init', 'slide_down_menus' );

if ( ! function_exists( 'slide_down_menus' ) ):
    function slide_down_menus() {
        register_nav_menus(
            array(
                'top-menu' => __( 'Menu du haut' )
            )
        );
    }
endif;

class description_walker extends Walker_Nav_Menu {
    function start_el(&$output, $item, $depth, $args) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class_names = ' class="'. esc_attr( $class_names ) . '"';
        $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
        $prepend = '<strong>';
        $append = '</strong>';
        $description  = ! empty( $item->description ) ? '<span>'.esc_attr( $item->description ).'</span>' : '';        //Si la description du lien n'est pas vide on l'enregistre
        if($depth != 0) {        //Si ce n'est pas un lien de premier niveau, on écrase tout
            $description = $append = $prepend = "";
        }
        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';        //On ouvre notre lien avec son url et ses classes
	if($item->menu_item_parent == 0) {        //S'il s'agit d'un lien de premier niveau
	    $item_output .= '<img src="'.get_bloginfo('template_directory').'/images/tab_'.$item->object.$item->object_id.'.jpg" alt="" />';        //L'image du lien
	    $item_output .= '<span class="tab_active">&nbsp;</span>';        //Le span nécessaire à l'animation
	    $item_output .= '<span class="tab_wrap">';
	    $item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;        //Le nom du lien (titre de la page)
	    $item_output .= $description.$args->link_after;        //La description
	    $item_output .= '</span></a>';        //On referme le lien
	} else {        //Si ce n'est pas un lien de premier niveau
	    $item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;        //Le nom du lien
	    $item_output .= $args->link_after.'</a>';        //On referme le lien
	}
        $item_output .= $args->after;
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }
}
?>