<?php
/*
Plugin Name: WP-Ajax-Gallery
Plugin URI: http://www.screenfeed.fr/blog/
Description: Search for all articles thumbnails in a category (an array of categories) and displays them (large size) whithin an image gallery AFTER page loading with an ajax/jQuery request. Just put <code>if ( class_exists('wp_ajax_gallery') ) wpAG();</code> in your template page. It also provides a link to each article and for a lightbox.
Version: 0.5
Author: Grégory Viguier
Author URI: http://www.screenfeed.fr/

This plugin inherits the GPL license from it's parent system, WordPress.
*/
if (!class_exists('wp_ajax_gallery')) {
class wp_ajax_gallery {
	//-------------------------------------------------------------------------- Variables -----------------------------
	var $wpdb;							// WP DB
	var $siteurl;						// Site url
	var $uploaddir;						// Upload directory
	var $plugindir;						// Plugin directory
	var $wp_query;						// Query


	//-------------------------------------------------------------------------- Construct -----------------------------
	function __construct() {
		global $wpdb;
		
		$this->wpdb = $wpdb;
		
		if (defined('WP_SITEURL'))
			$this->siteurl = WP_SITEURL;
		else
			$this->siteurl = get_bloginfo('url');
		
		$this->uploaddir = $this->wpdb->get_row("SELECT option_value "
												."FROM ".$this->wpdb->options." "
												."WHERE option_name = 'upload_path' ", ARRAY_N);
		$this->uploaddir = $this->uploaddir[0];
		
		if(strlen($this->uploaddir) == 0)
			$this->uploaddir = $this->siteurl.'/wp-content/uploads';
		else
			$this->uploaddir = $this->siteurl.'/'.$this->uploaddir;
		
		$this->plugindir = plugin_dir_url( __FILE__ );
		
		add_action("wp_ajax_nopriv_taking_chopsticks", array(&$this, 'eating_sushis'));
		add_action("wp_ajax_taking_chopsticks", array(&$this, 'eating_sushis'));
		if (!is_admin()) {
			wp_enqueue_script('wpAG', $this->plugindir.'ajax.js.php', array('jquery'), '1', true);
		}
	}


	//-------------------------------------------------------------------------- Renvoie les infos du thumbnail ---
	function eating_sushis() {
		if (isset($_GET['sushi'])) {
			$ramen = trim ( $_GET['sushi'][0], "[]" );
			$ramen = 'post_id = '.str_replace(',', ' OR post_id = ', $ramen);
			$sashimi = $this->wpdb->get_results("SELECT m.meta_value AS thumbmetas, t.post_title AS thtitle, p.ID AS pid "
											."FROM ".$this->wpdb->postmeta." m "
											."JOIN ".$this->wpdb->posts." t "
											."JOIN ".$this->wpdb->posts." p "
											."ON  m.post_id = t.ID "
											."AND t.post_parent = p.ID "
											."WHERE (".$ramen.") "
											."AND   m.meta_key = '_wp_attachment_metadata' "
											."ORDER BY p.post_date DESC");
			$thumbs = array();
			for ($num = 0; $num < count($sashimi); $num++) {
			$thumbtmp = unserialize($sashimi[$num]->thumbmetas);
			$thumbs[$num] = array('href' => $thumbtmp['file'], 'src' => $thumbtmp['sizes']['large']['file'], 'width' => $thumbtmp['sizes']['large']['width'], 'height' => $thumbtmp['sizes']['large']['height'], 'caption' => $sashimi[$num]->thtitle, 'pid' => $sashimi[$num]->pid);
			}
			echo json_encode($thumbs);
		} else die('-1');
		exit();
	}


	//-------------------------------------------------------------------------- Fonction principale --------------
	function ajax_gallery() {
		
		global $wp_query;
		
		$menusjap = $this->wpdb->get_results("SELECT term_taxonomy_id AS catid "
											."FROM ".$this->wpdb->term_taxonomy." "
											."WHERE taxonomy         = 'category' "
											."AND   count           != '0' "
											."AND  (term_taxonomy_id = '".$wp_query->query_vars['cat']."' "
											."OR    parent           = '".$wp_query->query_vars['cat']."')");
		
		for ($num = 0; $num < count($menusjap); $num++) {
			if ($num == 0) $imhungry = " "; else $imhungry .= "OR ";
			$imhungry .= "r.term_taxonomy_id = ".$menusjap[$num]->catid." ";
		}
		$sushis = $this->wpdb->get_results("SELECT m.meta_value AS thumbid "
											."FROM ".$this->wpdb->term_relationships." r "
											."JOIN ".$this->wpdb->posts." p "
											."JOIN ".$this->wpdb->postmeta." m "
											."ON  r.object_id = p.ID "
											."AND m.post_id = p.ID "
											."WHERE (".$imhungry.") "
											."AND   p.post_status = 'publish' "
											."AND   m.meta_key = '_thumbnail_id'");
		
		$nbrsushis = count($sushis);
		if ($nbrsushis > 0) {
			$yummy  = 'var yummy =  new Array(';
			for ($maki = 0; $maki < $nbrsushis; $maki++) {
				$yummy  .= '"'.$sushis[$maki]->thumbid.'"';
				if ($maki < ($nbrsushis-1)) {
					$yummy  .= ',';
				}
			}
			$yummy .= ');';
			echo '<script type="text/javascript">'.$yummy.'</script>';
			echo '<div class="post" id="gallery-wrap">'.
					'<div id="wpAGloading">'.
						'&nbsp;'.
					'</div>'.
					'<ul id="gallery-wrapin">'.
						'<li id="wpAGempty">&nbsp;</li>'.
					'</ul>'.
					'<div id="wpAGprev"><div>&nbsp;</div></div><div id="wpAGnext"><div>&nbsp;</div></div>'.
					'<div id="wpAGprev5"><div><span>Reculer de 5</span></div></div><div id="wpAGnext5"><div><span>Avancer de 5</span></div></div>'.
				 '</div>';
		}
	}
}
$wp_ajax_gallery = new wp_ajax_gallery();

function wpAG(){
	global $wp_ajax_gallery;
	echo $wp_ajax_gallery->ajax_gallery();
}
}
?>