/* ----------------------------------------------------------------------------*
 * Class: WPcaptionSlice
 * Use: split Wordpress captions into small captions with jQuery
 * Author: Grégory Viguier (http://www.screenfeed.fr/blog)
 * Version: 1.0
 * Needed: You need to set the var templdir for the blank.png path. In the plugin, the path is defined like this: src="'+templdir+'/js/WPcaptionSlice/blank.png" '. Example: <script type="text/javascript">var templdir="<?php bloginfo('template_directory'); ?>";</script>
 * --------------------------------------------------------------------------- */
(function($){$.fn.WPcaptionSlice=function(params){

	params = $.extend( {															// Default params
						width: 150,						// Images width
						height: 150,					// Images height
						cols: 3,						// Number of columns
						lines: 2,						// Number of lines
						xmin: 5,						// Minimum background-position x%
						xmax: 95,						// Maximum background-position x%
						ymin: 0,						// Minimum background-position y%
						ymax: 100,						// Maximum background-position y%
						captionPos: 0,					// Caption text position : 0 for none
						whiteSpace: true,				// White space under the images. true: white space is displayed. false: no white space. 'some text': specify a custom "white space" text
						galleryClass: '',				// Additional class for the gallery
						shuffle: false,					// Shuffle mode. Use 'fixedCaption' to fix the caption text position
						imgAlt: true,					// Use original image alt
						imgTitle: true,					// Use original image title
						linkToImg: true,				// Each "box" links to the image
						linkTitle: false,				// Use original link title
						linkRel: false,					// Use original link rel. Use a 'string' for a custom value
						imgAltToLinkTitle: false,		// Take the original image alt and put it into link title
						imgTitleToLinkTitle: false,		// Take the original image title and put it into link title
						boxDeltaWidth: 10,				// Box width - image width
						boxTag: 'div',					// HTML box tag
						textTag: 'p'					// HTML caption text tag
					}, params);

	if(params.cols<1) params.cols=1; else params.cols = Math.round(params.cols);	// We need at least 1 column and 1 row
	if(params.lines<1) params.lines=1; else params.lines = Math.round(params.lines);

	function getbgpos(iter, nbr, posmin, posmax) {									// The function that calculate the background positions
		if(nbr>1) {																	// If the number of columns or rows is egual to 1, we set the background position to 50% (or we'll divide by 0)
			b = ((nbr*posmin)-posmax)/(nbr-1);
			pos = (posmin-b)*iter+b;
		} else {
			pos = 50;
		}
		return pos;
	}

	var bgpos = new Array(2);														// An array for the background positions and fill it whith the values for all images
	bgpos['x'] = new Array(params.cols);
	bgpos['y'] = new Array(params.lines);
	for(k=0; k<params.cols; k++) {
		bgpos['x'][k] = getbgpos(k+1, params.cols, params.xmin, params.xmax);
	}
	for(l=0; l<params.lines; l++) {
		bgpos['y'][l] = getbgpos(l+1, params.lines, params.ymin, params.ymax);
	}

	var version=0;
	if (navigator.appVersion.indexOf("MSIE")!=-1) {									// Detecting IE for CSS bugs (yes, IE must die)
		temp=navigator.appVersion.split("MSIE");
		version=parseFloat(temp[1]);
	}

	this.each(function(i){
		caption = new Array;														// An array with all we need for the image, the link and the caption
		caption['img']  = $(this);
		caption['src']  = caption['img'].attr('src');
		caption['box']  = caption['img'].parents('.wp-caption');
		caption['id']   = caption['box'].attr('id');
		caption['lnk']  = caption['box'].find('a');
		caption['href'] = caption['lnk'].attr('href');
		if (typeof(caption['href']) !== 'undefined') {
			caption['hasa'] = true;
			if (typeof(params.linkRel) === 'string')
				caption['rel'] = ' rel="'+params.linkRel+'"';
			else if (params.linkRel )
				caption['rel'] = ' rel="'+caption['lnk'].attr('rel')+'"';
			else
				caption['rel'] = '';
		}
		else {
			caption['hasa'] = false;
			caption['rel'] = '';
		}

		if (params.linkToImg) {														// If we want a link to the image displayed in the post
			caption['href'] = caption['src'];
			caption['hasa'] = true;
		}

		if (params.imgAlt)
			caption['alt']  = caption['img'].attr('alt');
		else
			caption['alt']  = '';

		if (params.imgTitle)
			caption['tlt']  = ' title="'+caption['img'].attr('title')+'"';
		else
			caption['tlt']  = '';

		if (caption['hasa']) {
			if (params.linkTitle && !params.linkToImg)								// What do we want in the link title?
				caption['atlt'] = ' title="'+caption['lnk'].attr('title')+'"';
			else if (params.imgTitleToLinkTitle)
				caption['atlt'] = ' title="'+caption['img'].attr('title')+'"';
			else if (params.imgAltToLinkTitle)
				caption['atlt'] = ' title="'+caption['img'].attr('alt')+'"';
			else
				caption['atlt'] = '';
		}

		if (params.captionPos)														// The caption text
			caption['txt']  = caption['box'].find('.wp-caption-text').html();

		var lines = new Array;
		for(j=0; j<(params.cols*params.lines); j++) {

			bgxpos = bgpos['x'][j-(Math.floor(j/params.cols)*params.cols)];			// Pick the right background positions in the array
			bgypos = bgpos['y'][Math.floor(j/params.cols)];

			if ((j/params.cols == Math.round(j/params.cols)) && j>0 && !params.shuffle) {	// If params.shuffle is true, we'll deal with clear later
				if (version>0 && version<8) {
					clear = '';
				clearIE = '<span style="display:block;clear:left;height:0;line-height:0;">&nbsp;</span>';
				} else {
					clear = ' clear: left;';
					clearIE = '';
				}
			} else {
				clear = '';
				clearIE = '';
			}
			boxWidth = params.width+params.boxDeltaWidth;
			line = clearIE+'<'+params.boxTag+' class="wp-caption wp-caption'+params.width+'" style="float: left; width: '+boxWidth+'px;'+clear+'">';
			if (caption['hasa'])
				line += '<a href="'+caption['href']+'"'+caption['atlt']+caption['rel']+'>';
			if (templdir != '')
				line += '<img src="'+templdir+'/js/WPcaptionSlice/blank.png" ';
			else
				line += '<img src="js/WPcaptionSlice/blank.png" ';
			line += 'style="display:block; width: '+params.width+'px; height: '+params.height+'px; background:transparent url(\''+caption['src']+'\') '+bgxpos+'% '+bgypos+'% no-repeat;" '
					+'alt="'+caption['alt']+'"'+caption['tlt']+' />';
			if (caption['hasa'])
				line += '</a>';
			if ((j+1 == params.captionPos) && (params.shuffle != 'fixedCaption'))	// If we want the caption text (for the fixedCaption, we'll deal with it later)
				line += '<'+params.textTag+' class="wp-caption-text">'+caption['txt']+'</'+params.textTag+'>';
			else if ( typeof(params.whiteSpace) === 'boolean' && params.whiteSpace )
				line += '<'+params.textTag+' class="wp-caption-text">&nbsp;</'+params.textTag+'>';
			else if ( typeof(params.whiteSpace) === 'string' )
				line += '<'+params.textTag+' class="wp-caption-text">'+params.whiteSpace+'</'+params.textTag+'>';
			line += '</'+params.boxTag+'>';
			lines[j] = line;
		}

		if (params.shuffle) {
			Array.prototype.shuffle = function (){									// Shuffle function
				var i = this.length, j, temp;
				if ( i == 0 ) return;
				while ( --i ) {
					j = Math.floor( Math.random() * ( i + 1 ) );
					temp = this[i];
					this[i] = this[j];
					this[j] = temp;
				}
			};
			lines.shuffle();
		}

		var output = '';
		for(j=0; j<(params.cols*params.lines); j++) {
			output += lines[j];
		}

		caption['box'].removeClass('wp-caption')
			.addClass(params.galleryClass+' captionSlice')
			.removeAttr('style')
			.html(output+'<span style="clear: left; display: block; height: 0;">&nbsp;</span>');	// We delete the initial [caption] and put our images

		if (params.shuffle) {														// If params.shuffle is not false, we have to clear some wp-captions now, and add a caption text perhaps
			if (params.captionPos && (params.shuffle == 'fixedCaption')) {			// We need a caption text somewhere
				sushi = $('#'+caption['id']+' .wp-caption:nth-child('+params.captionPos+')');
				if ( params.whiteSpace )
					sushi.find('.wp-caption-text').html(caption['txt']);
				else
					sushi.append('<'+params.textTag+' class="wp-caption-text">'+caption['txt']+'</'+params.textTag+'>');
			}
																					// Clear some wp-captions
			sashimi = params.cols+1;
			if (version>0 && version<8)
				$('#'+caption['id']+' .wp-caption:nth-child('+params.cols+'n+'+sashimi+')').before('<span style="display:block;clear:left;height:0;line-height:0;">&nbsp;</span>');
			else
				$('#'+caption['id']+' .wp-caption:nth-child('+params.cols+'n+'+sashimi+')').css('clear','left');
		}

	});
	return this;
}})(jQuery);