<?php
/*
Plugin Name: WPML Switcher in admin bar
Plugin URI: http://scri.in/wpmladmb
Description: Moves the WPML admin language switcher to the admin bar. Really usefull in WordPress 3.3. All credits to the WPML team, I only made this tweak ;)
Version: 1.1.4
Author: Grégory Viguier
Author URI: http://scri.in/greg
*/

DEFINE( 'WPML_SIADMB_PLUGIN_URL', trailingslashit( WP_PLUGIN_URL ) . basename( dirname( __FILE__ ) ) );
DEFINE( 'WPML_SIADMB_DOMAIN', 'wpmlsiadmb' );


/* Language support */
add_action( 'init', 'admb_lang_init' );
function admb_lang_init() {
	load_plugin_textdomain( WPML_SIADMB_DOMAIN, false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}


/* Init */
add_action('plugins_loaded', 'language_switcher_in_admb_init');
function language_switcher_in_admb_init() {
	if (is_admin() && class_exists('SitePress')) {											// Only in admin area and if WPML is active
		global $sitepress;
		remove_action('in_admin_header', array($sitepress, 'admin_language_switcher'));		// First, I need to deactivate the switcher and do my stuff later, much easier for hooks
		add_action( 'admin_init', 'language_switcher_in_admb_hooks' );						// Now I can do my job safely :)
	}
}
function language_switcher_in_admb_hooks() {
	$current_user = wp_get_current_user();
	if ( class_exists('WP_Screen') ) {														// WP 3.3+

		add_action( 'admin_bar_menu', 'language_switcher_in_admb', 99 );
		remove_action('admin_notices', 'wpml_set_admin_language_switcher_place', 100);		// Don't add the useless <br clear="all" />

		wp_enqueue_style( 'wp-pointer' );
		wp_enqueue_style( 'sitepress-siadmb-style', WPML_SIADMB_PLUGIN_URL . '/res/css/wpmliadmb.css', 'wp-pointer', ICL_SITEPRESS_VERSION );

		wp_enqueue_script( 'wp-pointer' );
		wp_enqueue_script('sitepress-siadmb-pointers', WPML_SIADMB_PLUGIN_URL . '/res/js/pointers.js', array('wp-pointer'), ICL_SITEPRESS_VERSION, 1);
		$params = array( 'content' => '<p>'.sprintf(__('This language selector determines which content to display. You can choose items in a specific language or in all languages. To change the language of the WordPress Admin interface, go to <a%s>your profile</a>.', 'sitepress'), ' href="'.admin_url('profile.php').'"').'</p>', 'title' => __('Language selector', WPML_SIADMB_DOMAIN) );
		wp_localize_script( 'sitepress-siadmb-pointers', 'siadmb', $params );

	} elseif ( class_exists('WP_Admin_Bar') && $current_user->show_admin_bar_admin ) {		// WP 3.0+ and admin bar enabled

		add_action( 'admin_bar_menu', 'language_switcher_in_admb', 99 );
		wp_enqueue_style( 'sitepress-siadmb-style', WPML_SIADMB_PLUGIN_URL . '/res/css/wpmliadmb.css', false, ICL_SITEPRESS_VERSION );

	} else {																				// WP < 3.0

		global $sitepress;
		add_action('in_admin_header', array($sitepress, 'admin_language_switcher'));

	}
}


/* Build the old popup window */
function admb_icl_pop_info($message) {
	$box = '<div class="icl_cyan_box icl_pop_info">'
			 . '<img align="right" src="' . ICL_PLUGIN_URL . '/res/img/ico-close.png" width="12" height="12" alt="x" onclick="jQuery(this).parent().fadeOut().parents(\'#wp-admin-bar-wpml-lng-sw\').removeClass(\'stay-open\');" />'
			 . $message
		 . '</div>';
	return $box;
}


/* The switcher */
function language_switcher_in_admb( $wp_admin_bar ) {
    global $pagenow, $wpdb, $sitepress;

    $all_langs_enabled = true;
    $current_page = basename($_SERVER['SCRIPT_NAME']);

    // individual translations
    $is_post = false;
    $is_tax = false;
    $is_menu = false;
    switch($pagenow){
        case 'post.php':
            $is_post = true;
            $all_langs_enabled = false;
            $post_id =  @intval($_GET['post']);
            $post = get_post($post_id);

            $trid = $sitepress->get_element_trid($post_id, 'post_' . $post->post_type);
            $translations = $sitepress->get_element_translations($trid, 'post_' . $post->post_type, true);

            break;
        case 'post-new.php':
            $all_langs_enabled = false;
            if(isset($_GET['trid'])){
                $trid = $_GET['trid'];
                $post_type = isset($_GET['post_type']) ? $_GET['post_type'] : 'post';
                $translations = $sitepress->get_element_translations($trid, 'post_' . $post_type, true);
                $is_post = true;
            }
            break;
        case 'edit-tags.php':
            $is_tax = true;
            if(isset($_GET['action']) && $_GET['action']=='edit'){
                $all_langs_enabled = false;
            }  
            $term_id = @intval($_GET['tag_ID']);  
            $taxonomy = $_GET['taxonomy'];
            $term_tax_id = $wpdb->get_var($wpdb->prepare("SELECT term_taxonomy_id FROM {$wpdb->term_taxonomy} WHERE taxonomy=%s AND term_id=%d", $taxonomy, $term_id));

            $trid = $sitepress->get_element_trid($term_tax_id, 'tax_' . $taxonomy);
            $translations = $sitepress->get_element_translations($trid, 'tax_' . $taxonomy, true);

            break;
        case 'nav-menus.php':
            $is_menu = true;
            if(isset($_GET['menu']) && $_GET['menu']){
                 $menu_id = $_GET['menu'];
                 $trid = $trid = $sitepress->get_element_trid($menu_id, 'tax_nav_menu');
                 $translations = $sitepress->get_element_translations($trid, 'tax_nav_menu', true);
            }
            $all_langs_enabled = false;
            break;
        
    }

    foreach($sitepress->get_active_languages() as $lang){

        $current_page_lang = $current_page;

        parse_str($_SERVER['QUERY_STRING'], $query_vars);
        unset($query_vars['lang'], $query_vars['admin_bar']);

        // individual translations
        if($is_post){
            if(isset($translations[$lang['code']]) && isset($translations[$lang['code']]->element_id)){
                $query_vars['post'] = $translations[$lang['code']]->element_id;
                unset($query_vars['source_lang']);
                $current_page_lang = 'post.php';
                $query_vars['action'] = 'edit';
            }else{
                $current_page_lang = 'post-new.php';
                if(isset($post)){
                    $query_vars['post_type'] = $post->post_type;
                    $query_vars['source_lang'] = $sitepress->get_current_language();
                }else{
                    $query_vars['post_type'] = $post_type;
                }  
                $query_vars['trid'] = $trid;
                unset($query_vars['post'], $query_vars['action']);
            }
        }elseif($is_tax){
            if(isset($translations[$lang['code']]) && isset($translations[$lang['code']]->element_id)){
                $query_vars['tag_ID'] = $translations[$lang['code']]->element_id;
            }else{
                $query_vars['trid'] = $trid;
                $query_vars['source_lang'] = $sitepress->get_current_language();
                unset($query_vars['tag_ID'], $query_vars['action']);
            }
        }elseif($is_menu){
            if(!empty($menu_id)){
                if(isset($translations[$lang['code']]->element_id)){
                    $query_vars['menu'] = $translations[$lang['code']]->element_id;
                }else{
                    $query_vars['menu'] = 0;
                    $query_vars['trid'] = $trid;
                    $query_vars['action'] = 'edit';
                }
            }
        }

        $query_string = http_build_query($query_vars);

        $query = '?';
        if(!empty($query_string)){
            $query .= $query_string . '&';
        }
        $query .= 'lang=' . $lang['code']; // the default language need to specified explictly yoo in order to set the lang cookie

        $linkurl = admin_url($current_page_lang . $query);

        $flag = $sitepress->get_flag($lang['code']);

        if($flag->from_template){
            $wp_upload_dir = wp_upload_dir();
            $flag_url = $wp_upload_dir['baseurl'] . '/flags/' . $flag->flag;
        }else{
            $flag_url = ICL_PLUGIN_URL . '/res/flags/'.$flag->flag;
        }

        $langlinks[$lang['code']] = array(
            'url'       => $linkurl . '&admin_bar=1',
            'current'   => $lang['code'] == $sitepress->get_current_language(),
            'anchor'    => $lang['display_name'],
            'flag'      => '<img style="margin:0 6px -1px 0" src="'.$flag_url.'" alt="'.$lang['code'].'" width="18" height="12" />'
        );

    }

    if($all_langs_enabled){
        $query = '?';
        if(!empty($query_string)){
            $query .= $query_string . '&';
        }    
        $query .= 'lang=all'; 
        $linkurl = admin_url(basename($_SERVER['SCRIPT_NAME']) . $query);
       
        $langlinks['all'] = array(
            'url'       => $linkurl,
            'current'   => 'all' == $sitepress->get_current_language(),
            'anchor'    => __('All languages', 'sitepress'),
            'flag'      => '<img style="margin:0 6px -1px 0" src="'.ICL_PLUGIN_URL.'/res/img/icon16.png" alt="all" width="16" height="16" />'
        );
    }else{
        // set the default language as current
        if('all' == $sitepress->get_current_language()){
            $langlinks[$sitepress->get_default_language()]['current'] = true;
        }
    }

	//-------------------------------- Admin bar stuff ----------------------------------
	// First item: 'Content language'
	foreach($langlinks as $link) {
		if($link['current']) {
			$wp_admin_bar->add_menu( array(
				'id'     => 'wpml-lng-sw',
				'title'  => $link['flag'].__('Content language', WPML_SIADMB_DOMAIN),
				'href'   => str_replace('&','&amp;',str_replace('&amp;','&',$link['url']))			// Replace "&" with "&amp;" for XHTML validation but not really important
			) );
			break;
		}
	}

	// All languages
	foreach($langlinks as $l => $link) {
		$linkArr = array(
				'parent' => 'wpml-lng-sw',
				'id'     => 'wpml-lng-'.$l,
				'title'  => $link['flag'].$link['anchor'],
				'href'   => str_replace('&','&amp;',str_replace('&amp;','&',$link['url']))
		);
		if($link['current'])
			$linkArr['meta'] = array(
				'title' => __('Active language', WPML_SIADMB_DOMAIN),			// Title property for the link
				'class' => 'active-lang',										// Add a class to the item, optional
				'html'  => '<span class="arrow"><br/></span>',					// Add a small triangle for the active language
			);
		$wp_admin_bar->add_menu( $linkArr );
	}

	// Help item
	$help_item = array(
		'parent' => 'wpml-lng-sw',
		'id'     => 'wpml-help',
		'title'  => __('What&#8217;s this?', WPML_SIADMB_DOMAIN),
		'href'   => '#',
		'secondary' => true
	);
	if ( !class_exists('WP_Screen') ) {											// < WP 3.3
		$message = sprintf(__('This language selector determines which content to display. You can choose items in a specific language or in all languages. To change the language of the WordPress Admin interface, go to <a%s>your profile</a>.', 'sitepress'), ' href="'.admin_url('profile.php').'"');
		$help_item['meta'] = array(
			'onclick' => "jQuery(this).blur().parents(\"#wp-admin-bar-wpml-lng-sw\").addClass(\"stay-open\").find(\".icl_pop_info\").fadeIn();return false;",
			'html'    => admb_icl_pop_info($message)
		);
	}
	$wp_admin_bar->add_menu( $help_item );

}


?>